<?php
final class AuthController
{
  public function login(): void
  {
    $pdo = Db::pdo();
    $error = null;

    // sudah login
    if (!empty($_SESSION['auth'])) {
      $this->redirectByRole($_SESSION['auth']['role']);
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      $username = trim($_POST['username'] ?? '');
      $password = (string)($_POST['password'] ?? '');

      if ($username === '' || $password === '') {
        $error = 'Username dan password wajib diisi.';
      } else {
        $st = $pdo->prepare("
          SELECT id, username, password_hash, role, status
          FROM members
          WHERE username=?
          LIMIT 1
        ");
        $st->execute([$username]);
        $u = $st->fetch();

        if (!$u || !password_verify($password, $u['password_hash'])) {
          $error = 'Username atau password salah.';
        } elseif ($u['status'] !== 'active') {
          $error = 'Akun belum aktif atau diblokir.';
        } else {
          $_SESSION['auth'] = [
            'id' => (int)$u['id'],
            'username' => $u['username'],
            'role' => $u['role'],
          ];
          $this->redirectByRole($u['role']);
        }
      }
    }

    require __DIR__ . '/../views/auth/login.php';
  }

  private function redirectByRole(string $role): void
  {
    if ($role === 'admin') {
      redirect('/jwdnetwork/admin.php');
    } else {
      redirect('/jwdnetwork/member.php');
    }
  }

  public function logout(): void
  {
    unset($_SESSION['auth']);
    session_destroy();
    redirect('/jwdnetwork/public/?r=login');
  }
}
