<?php
// app/controllers/RegisterController.php

final class RegisterController
{
  public function register(): void
  {
    $pdo = Db::pdo();
    $error = null;
    $success = null;

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      $username = trim($_POST['username'] ?? '');
      $password = (string)($_POST['password'] ?? '');
      $password2 = (string)($_POST['password2'] ?? '');
      $fullName = trim($_POST['full_name'] ?? '');
      $phone = trim($_POST['phone'] ?? '');
      $sponsorUsername = trim($_POST['sponsor'] ?? '');

      // ✅ PIN WAJIB
      $pin = strtoupper(trim($_POST['pin'] ?? ''));

      if ($pin === '') {
        $error = 'PIN Aktivasi wajib diisi.';
      } elseif ($username === '' || $password === '' || $password2 === '') {
        $error = 'Username dan password wajib diisi.';
      } elseif ($password !== $password2) {
        $error = 'Password dan konfirmasi tidak sama.';
      }

      // cek username unik
      if (!$error) {
        $st = $pdo->prepare("SELECT id FROM members WHERE username=? LIMIT 1");
        $st->execute([$username]);
        if ($st->fetch()) $error = 'Username sudah digunakan.';
      }

      // cek sponsor (opsional)
      $sponsorId = null;
      if (!$error && $sponsorUsername !== '') {
        $st = $pdo->prepare("SELECT id FROM members WHERE username=? AND status='active' LIMIT 1");
        $st->execute([$sponsorUsername]);
        $s = $st->fetch();
        if (!$s) $error = 'Sponsor tidak ditemukan atau belum aktif.';
        else $sponsorId = (int)$s['id'];
      }

      if (!$error) {
        try {
          $pdo->beginTransaction();

          // ✅ cek PIN (harus unused)
          $st = $pdo->prepare("
            SELECT id, package_id, status
            FROM pins_activation
            WHERE pin_code=?
            LIMIT 1
            FOR UPDATE
          ");
          $st->execute([$pin]);
          $pinRow = $st->fetch();

          if (!$pinRow) {
            throw new Exception("PIN tidak ditemukan.");
          }
          if ($pinRow['status'] !== 'unused') {
            throw new Exception("PIN sudah digunakan.");
          }

          $packageId = (int)$pinRow['package_id'];
          if ($packageId <= 0) throw new Exception("PIN paket tidak valid.");

          // insert member pending + package dari PIN
          $hash = password_hash($password, PASSWORD_BCRYPT);

          $pdo->prepare("
            INSERT INTO members
              (username, password_hash, full_name, phone, sponsor_id, package_id, role, status)
            VALUES
              (?, ?, ?, ?, ?, ?, 'member', 'pending')
          ")->execute([
            $username,
            $hash,
            $fullName ?: null,
            $phone ?: null,
            $sponsorId,
            $packageId
          ]);

          $newMemberId = (int)$pdo->lastInsertId();

          // ✅ update PIN jadi used
          $pdo->prepare("
            UPDATE pins_activation
            SET status='used', used_by_member_id=?, used_at=NOW()
            WHERE id=?
          ")->execute([$newMemberId, (int)$pinRow['id']]);

          $pdo->commit();

          $success = 'Pendaftaran berhasil. Akun menunggu aktivasi (pending).';

        } catch (Throwable $e) {
          if ($pdo->inTransaction()) $pdo->rollBack();
          $error = $e->getMessage();
        }
      }
    }

    require __DIR__ . '/../views/auth/register.php';
  }
}
