<?php
// app/core/Helpers.php
function e($s) { return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

function redirect($url) {
  header("Location: {$url}");
  exit;
}

function flash_set($key, $msg) {
  $_SESSION['flash'][$key] = $msg;
}

function flash_get($key) {
  if (!empty($_SESSION['flash'][$key])) {
    $m = $_SESSION['flash'][$key];
    unset($_SESSION['flash'][$key]);
    return $m;
  }
  return null;
}
function paginate_meta(int $totalRows, int $page, int $perPage): array {
  $totalPages = (int)ceil($totalRows / $perPage);
  if ($totalPages < 1) $totalPages = 1;

  if ($page < 1) $page = 1;
  if ($page > $totalPages) $page = $totalPages;

  $offset = ($page - 1) * $perPage;

  return [
    'page' => $page,
    'perPage' => $perPage,
    'totalRows' => $totalRows,
    'totalPages' => $totalPages,
    'offset' => $offset,
  ];
}
