<?php
// app/services/Bonus/SponsorBonusService.php

final class SponsorBonusService
{
    /**
     * Jalankan sponsor bonus untuk member baru (sekali saja).
     * - sumber bonus: paket member baru (packages.sponsor_bonus)
     * - penerima: sponsor langsung (members.sponsor_id)
     */
    public static function run(PDO $pdo, int $newMemberId): array
    {
        // ambil data member baru
        $st = $pdo->prepare("
            SELECT id, sponsor_id, package_id, status
            FROM members
            WHERE id = ?
            LIMIT 1
        ");
        $st->execute([$newMemberId]);
        $m = $st->fetch();
        if (!$m) throw new Exception("Member baru tidak ditemukan");
        if ($m['status'] !== 'active') {
            return ['ok'=>true,'skipped'=>true,'reason'=>'member belum active'];
        }

        $sponsorId = (int)($m['sponsor_id'] ?? 0);
        $packageId = (int)($m['package_id'] ?? 0);

        if ($sponsorId <= 0) {
            return ['ok'=>true,'skipped'=>true,'reason'=>'tidak ada sponsor'];
        }
        if ($packageId <= 0) {
            return ['ok'=>true,'skipped'=>true,'reason'=>'package_id kosong'];
        }

        // ambil sponsor_bonus dari paket member baru
        $st = $pdo->prepare("SELECT sponsor_bonus, code FROM packages WHERE id=? LIMIT 1");
        $st->execute([$packageId]);
        $pkg = $st->fetch();
        if (!$pkg) throw new Exception("Paket tidak ditemukan");

        $amount = (float)$pkg['sponsor_bonus'];
        if ($amount <= 0) {
            return ['ok'=>true,'skipped'=>true,'reason'=>'sponsor_bonus paket = 0'];
        }

        // insert log sponsor bonus (idempotent: UNIQUE new_member_id)
        $stmt = $pdo->prepare("
            INSERT IGNORE INTO plan_a_bonus_sponsor
              (sponsor_id, new_member_id, new_package_id, amount)
            VALUES
              (?, ?, ?, ?)
        ");
        $stmt->execute([$sponsorId, $newMemberId, $packageId, $amount]);

        if ($stmt->rowCount() <= 0) {
            // sudah pernah dibayar
            return ['ok'=>true,'skipped'=>true,'reason'=>'sponsor bonus sudah ada'];
        }

        // kredit wallet sponsor
        $desc = "Bonus Sponsor dari member #{$newMemberId} (paket {$pkg['code']})";
        wallet_credit($pdo, $sponsorId, $amount, 'sponsor', $desc, 'plan_a_bonus_sponsor', (int)$pdo->lastInsertId());

        return [
            'ok' => true,
            'skipped' => false,
            'sponsor_id' => $sponsorId,
            'new_member_id' => $newMemberId,
            'package_id' => $packageId,
            'amount' => $amount
        ];
    }
}
