<?php
class PlanADailyBonusService
{
  private static function activate(PDO $pdo, int $memberId, string $type, float $amount): void
  {
    $start = date('Y-m-d');
    $end   = date('Y-m-d', strtotime($start . ' +89 days')); // 90 hari total

    try {
      $pdo->prepare("
        INSERT INTO plan_a_daily_bonus
          (member_id, bonus_type, amount_per_day, start_date, end_date, days_paid, last_paid_date, status)
        VALUES (?,?,?,?,?,0,NULL,'ACTIVE')
      ")->execute([$memberId, $type, $amount, $start, $end]);
    } catch (Throwable $e) {
      // sudah aktif → ignore
    }
  }

  // cek & aktivasi bonus harian
  public static function checkAndActivate(PDO $pdo, int $sponsorId): void
  {
    $st = $pdo->prepare("SELECT package_id FROM members WHERE id=? LIMIT 1");
    $st->execute([$sponsorId]);
    $pkg = (int)($st->fetchColumn() ?: 0);

    $st = $pdo->prepare("
      SELECT
        SUM(CASE WHEN package_id=2 THEN 1 ELSE 0 END) AS cnt_smart,
        SUM(CASE WHEN package_id=3 THEN 1 ELSE 0 END) AS cnt_rich
      FROM members
      WHERE sponsor_id=? AND status='active'
    ");
    $st->execute([$sponsorId]);
    $c = $st->fetch(PDO::FETCH_ASSOC);

    $cntSmart = (int)($c['cnt_smart'] ?? 0);
    $cntRich  = (int)($c['cnt_rich'] ?? 0);

    // SMART: 3 SMART → 50k / hari
    if ($pkg === 2 && $cntSmart >= 3) {
      self::activate($pdo, $sponsorId, 'SMART_3SMART', 50000);
    }

    // RICH: 3 RICH → 100k / hari
    if ($pkg === 3 && $cntRich >= 3) {
      self::activate($pdo, $sponsorId, 'RICH_3RICH', 100000);
    }
  }

  // runner harian
  public static function runDaily(PDO $pdo, ?string $dateYmd = null): array
  {
    $today = $dateYmd ?: date('Y-m-d');
    $pdo->beginTransaction();

    $st = $pdo->prepare("
      SELECT *
      FROM plan_a_daily_bonus
      WHERE status='ACTIVE'
        AND start_date <= ?
        AND end_date >= ?
        AND (last_paid_date IS NULL OR last_paid_date < ?)
      FOR UPDATE
    ");
    $st->execute([$today, $today, $today]);
    $rows = $st->fetchAll(PDO::FETCH_ASSOC);

    $paid = 0;

    foreach ($rows as $r) {
      if ((int)$r['days_paid'] >= 90) {
        $pdo->prepare("UPDATE plan_a_daily_bonus SET status='STOPPED' WHERE id=?")
            ->execute([(int)$r['id']]);
        continue;
      }

      $memberId = (int)$r['member_id'];
      $amt      = (float)$r['amount_per_day'];

      // ensure wallet
      $st2 = $pdo->prepare("SELECT member_id FROM wallets WHERE member_id=? LIMIT 1");
      $st2->execute([$memberId]);
      if (!$st2->fetch()) {
        $pdo->prepare("INSERT INTO wallets (member_id, balance) VALUES (?,0.00)")
            ->execute([$memberId]);
      }

      // tambah saldo
      $pdo->prepare("UPDATE wallets SET balance = balance + ? WHERE member_id=?")
          ->execute([$amt, $memberId]);

      // log transaksi
      $pdo->prepare("
        INSERT INTO wallet_transactions
          (member_id, tx_type, amount, description, ref_table, ref_id, created_at)
        VALUES (?, 'daily_bonus', ?, ?, 'plan_a_daily_bonus', ?, NOW())
      ")->execute([
        $memberId,
        $amt,
        "Bonus Harian Plan A ({$r['bonus_type']}) - {$today}",
        (int)$r['id']
      ]);

      $pdo->prepare("
        UPDATE plan_a_daily_bonus
        SET days_paid = days_paid + 1, last_paid_date = ?
        WHERE id=?
      ")->execute([$today, (int)$r['id']]);

      $paid++;
    }

    $pdo->commit();
    return ['ok'=>true,'date'=>$today,'paid_count'=>$paid,'candidates'=>count($rows)];
  }
}
