<?php
class PlanAMatchingService
{
  public static function amountAndCapByReceiverPkg(int $pkgId): array
  {
    // sesuai rule TERBARU kamu
    if ($pkgId === 1) return [10000, 10];  // WARRIOR
    if ($pkgId === 2) return [20000, 20];  // SMART
    if ($pkgId === 3) return [100000, 20]; // RICH
    return [0, 0];
  }

  private static function ensureWallet(PDO $pdo, int $memberId): void
  {
    $st = $pdo->prepare("SELECT member_id FROM wallets WHERE member_id=? LIMIT 1 FOR UPDATE");
    $st->execute([$memberId]);
    if (!$st->fetch()) {
      $pdo->prepare("INSERT INTO wallets (member_id, balance) VALUES (?, 0.00)")->execute([$memberId]);
    }
  }

  // dipanggil ketika ada placement baru terjadi pada sebuah parent node
  public static function onNodeMaybePaired(PDO $pdo, int $nodeId): void
  {
    // cek nodeId sudah punya L dan R?
    $st = $pdo->prepare("
      SELECT
        SUM(CASE WHEN leg='L' THEN 1 ELSE 0 END) AS hasL,
        SUM(CASE WHEN leg='R' THEN 1 ELSE 0 END) AS hasR
      FROM binary_placements
      WHERE parent_id=?
    ");
    $st->execute([$nodeId]);
    $x = $st->fetch(PDO::FETCH_ASSOC);
    $hasL = ((int)($x['hasL'] ?? 0)) > 0;
    $hasR = ((int)($x['hasR'] ?? 0)) > 0;
    if (!$hasL || !$hasR) return;

    // buat pair event (anti double) - untuk sekarang hanya pair_index=1 (pair pertama)
    try {
      $pdo->prepare("INSERT INTO plan_a_pair_events (member_id, pair_index) VALUES (?,1)")
          ->execute([$nodeId]);
      $pairEventId = (int)$pdo->lastInsertId();
    } catch (Throwable $e) {
      // sudah pernah dibayar
      return;
    }

    // sponsor chain: gen1 sponsor nodeId, gen2 sponsor dari sponsor, dst
    $cur = $nodeId;
    $gen = 1;

    while (true) {
      $st = $pdo->prepare("SELECT sponsor_id FROM members WHERE id=? LIMIT 1");
      $st->execute([$cur]);
      $sponsorId = (int)($st->fetchColumn() ?: 0);
      if ($sponsorId <= 0) break;

      // paket penerima
      $st = $pdo->prepare("SELECT package_id FROM members WHERE id=? LIMIT 1");
      $st->execute([$sponsorId]);
      $recvPkg = (int)($st->fetchColumn() ?: 0);

      list($amt, $cap) = self::amountAndCapByReceiverPkg($recvPkg);

      if ($amt > 0 && $cap > 0 && $gen <= $cap) {
        // anti double receiver per event
        $ok = true;
        try {
          $pdo->prepare("
            INSERT INTO plan_a_matching_logs (pair_event_id, receiver_id, gen, amount)
            VALUES (?,?,?,?)
          ")->execute([$pairEventId, $sponsorId, $gen, $amt]);
        } catch (Throwable $e) {
          $ok = false;
        }

        if ($ok) {
          self::ensureWallet($pdo, $sponsorId);

          $pdo->prepare("UPDATE wallets SET balance = balance + ? WHERE member_id=?")
              ->execute([$amt, $sponsorId]);

          $desc = "Matching Gen {$gen} dari pair member #{$nodeId}";
          $pdo->prepare("
            INSERT INTO wallet_transactions (member_id, tx_type, amount, description, ref_table, ref_id, created_at)
            VALUES (?, 'matching', ?, ?, 'plan_a_pair_events', ?, NOW())
          ")->execute([$sponsorId, $amt, $desc, $pairEventId]);
        }
      }

      $cur = $sponsorId;
      $gen++;
      if ($gen > 200) break; // safety
    }
  }
}
