<?php
class PlanARewardService
{
  // mapping paket -> poin reward
  public static function pointsByPackageId(int $pkgId): int
  {
    if ($pkgId === 2) return 1; // SMART
    if ($pkgId === 3) return 2; // RICH
    return 0;
  }

  // hanya member SMART/RICH yang berhak dapat reward
  public static function eligibleReceiverPkg(int $pkgId): bool
  {
    return in_array($pkgId, [2,3], true);
  }

  // cek milestone reward (anti dobel lewat UNIQUE uq_member_milestone)
  private static function checkMilestones(PDO $pdo, int $memberId): void
  {
    $st = $pdo->prepare("
      SELECT
        COALESCE(SUM(CASE WHEN leg='L' THEN points ELSE 0 END),0) AS left_pts,
        COALESCE(SUM(CASE WHEN leg='R' THEN points ELSE 0 END),0) AS right_pts
      FROM plan_a_reward_points
      WHERE member_id=?
    ");
    $st->execute([$memberId]);
    $t = $st->fetch(PDO::FETCH_ASSOC);
    $L = (int)($t['left_pts'] ?? 0);
    $R = (int)($t['right_pts'] ?? 0);

    // daftar target (sesuai plan kamu)
    $targets = [
      ['code'=>'MOTOR_20',  'name'=>'Motor',  'value'=>10000000,  'need'=>20],
      ['code'=>'BRIO_200',  'name'=>'Brio',   'value'=>120000000, 'need'=>200],
      ['code'=>'PAJERO_1200','name'=>'Pajero','value'=>500000000, 'need'=>1200],
    ];

    foreach ($targets as $x) {
      if ($L >= $x['need'] && $R >= $x['need']) {
        // insert milestone (jika sudah ada, ignore via try/catch)
        try {
          $pdo->prepare("
            INSERT INTO plan_a_reward_milestones
              (member_id, milestone_code, reward_name, reward_value, left_needed, right_needed, achieved_at)
            VALUES (?,?,?,?,?,?,NOW())
          ")->execute([$memberId, $x['code'], $x['name'], $x['value'], $x['need'], $x['need']]);
        } catch (Throwable $e) {
          // sudah pernah dapat milestone ini
        }
      }
    }
  }

  // MAIN: dipanggil saat member baru ACTIVE & sudah punya placement
  public static function onMemberActivated(PDO $pdo, int $newMemberId): void
  {
    // ambil paket member baru (sumber poin)
    $st = $pdo->prepare("SELECT package_id FROM members WHERE id=? LIMIT 1");
    $st->execute([$newMemberId]);
    $srcPkg = (int)($st->fetchColumn() ?: 0);

    $pts = self::pointsByPackageId($srcPkg);
    if ($pts <= 0) return; // hanya SMART/RICH yang menghasilkan poin

    // ambil placement member baru
    $st = $pdo->prepare("SELECT parent_id, leg FROM binary_placements WHERE member_id=? LIMIT 1");
    $st->execute([$newMemberId]);
    $pl = $st->fetch(PDO::FETCH_ASSOC);
    if (!$pl) return;

    $curNodeId = $newMemberId;
    $parentId  = (int)$pl['parent_id'];
    $legToParent = strtoupper((string)$pl['leg']); // L/R

    $guard = 0;
    while ($parentId > 0) {
      // receiver (upline) harus SMART/RICH
      $st = $pdo->prepare("SELECT package_id FROM members WHERE id=? LIMIT 1");
      $st->execute([$parentId]);
      $recvPkg = (int)($st->fetchColumn() ?: 0);

      if (self::eligibleReceiverPkg($recvPkg) && in_array($legToParent, ['L','R'], true)) {
        // insert poin
        $pdo->prepare("
          INSERT INTO plan_a_reward_points
            (member_id, leg, points, source_member_id, source_package_id, created_at)
          VALUES (?,?,?,?,?,NOW())
        ")->execute([$parentId, $legToParent, $pts, $newMemberId, $srcPkg]);

        // cek milestone tiap kali bertambah
        self::checkMilestones($pdo, $parentId);
      }

      // naik ke atas: cari placement dari parentId (parentId adalah cur node sekarang)
      $st = $pdo->prepare("SELECT parent_id, leg FROM binary_placements WHERE member_id=? LIMIT 1");
      $st->execute([$parentId]);
      $ppl = $st->fetch(PDO::FETCH_ASSOC);

      if (!$ppl) break;
      $legToParent = strtoupper((string)$ppl['leg']);
      $parentId = (int)$ppl['parent_id'];

      if (++$guard > 5000) break; // safety
    }
  }
}
