<?php
$pdo = Db::pdo();

function rupiah($n){ return 'Rp ' . number_format((float)$n, 0, ',', '.'); }

// members
$totalMembers = (int)$pdo->query("SELECT COUNT(*) FROM members WHERE role='member'")->fetchColumn();
$activeMembers = (int)$pdo->query("SELECT COUNT(*) FROM members WHERE role='member' AND status='active'")->fetchColumn();
$joinToday = (int)$pdo->query("SELECT COUNT(*) FROM members WHERE role='member' AND DATE(created_at)=CURDATE()")->fetchColumn();

// pending wd
$st = $pdo->query("SELECT COUNT(*) cnt, COALESCE(SUM(amount),0) amt FROM withdraw_requests WHERE status='pending'");
$wd = $st->fetch(PDO::FETCH_ASSOC);
$wdPendingCnt = (int)($wd['cnt'] ?? 0);
$wdPendingAmt = (float)($wd['amt'] ?? 0);

// sponsor payout today
$st = $pdo->query("SELECT COALESCE(SUM(amount),0) FROM wallet_transactions WHERE tx_type='sponsor' AND DATE(created_at)=CURDATE()");
$sponsorToday = (float)$st->fetchColumn();

// omzet join hari ini (pakai packages.price dari members join today)
$st = $pdo->query("
  SELECT COALESCE(SUM(p.price),0)
  FROM members m
  JOIN packages p ON p.id=m.package_id
  WHERE m.role='member' AND DATE(m.created_at)=CURDATE()
");
$omzetToday = (float)$st->fetchColumn();

// pins unused
$pinsUnused = (int)$pdo->query("SELECT COUNT(*) FROM pins_activation WHERE status='unused'")->fetchColumn();

// latest WD 8
$st = $pdo->query("
  SELECT w.id, w.amount, w.status, w.requested_at, m.username, w.bank_name, w.bank_account
  FROM withdraw_requests w
  JOIN members m ON m.id=w.member_id
  ORDER BY w.id DESC
  LIMIT 8
");
$lastWd = $st->fetchAll(PDO::FETCH_ASSOC);

// latest tx 8
$st = $pdo->query("
  SELECT w.id, w.tx_type, w.amount, w.created_at, m.username, w.description
  FROM wallet_transactions w
  JOIN members m ON m.id=w.member_id
  ORDER BY w.id DESC
  LIMIT 8
");
$lastTx = $st->fetchAll(PDO::FETCH_ASSOC);

// omzet last 7 days (join)
$st = $pdo->query("
  SELECT DATE(m.created_at) d, COALESCE(SUM(p.price),0) amt
  FROM members m
  JOIN packages p ON p.id=m.package_id
  WHERE m.role='member' AND m.created_at >= DATE_SUB(CURDATE(), INTERVAL 6 DAY)
  GROUP BY DATE(m.created_at)
  ORDER BY d ASC
");
$days = [];
$amts = [];
$map = [];
foreach ($st->fetchAll(PDO::FETCH_ASSOC) as $r) $map[$r['d']] = (float)$r['amt'];
for ($i=6; $i>=0; $i--) {
  $d = date('Y-m-d', strtotime("-$i day"));
  $days[] = $d;
  $amts[] = $map[$d] ?? 0;
}
?>

<style>
.kpi-card{border:0;border-radius:16px;box-shadow:0 10px 30px rgba(0,0,0,.06)}
.kpi-icon{width:44px;height:44px;border-radius:14px;display:flex;align-items:center;justify-content:center;background:rgba(0,0,0,.06)}
.soft-card{border:0;border-radius:16px;box-shadow:0 10px 30px rgba(0,0,0,.06)}
</style>

<div class="row g-3">

  <div class="col-12">
    <div class="soft-card card">
      <div class="card-body d-flex flex-wrap justify-content-between align-items-center gap-3">
        <div>
          <div class="text-secondary small">Admin Overview</div>
          <div class="fs-4 fw-bold mb-1">JWD NETWORK</div>
          <div class="small text-secondary">
            Join today: <b><?= (int)$joinToday ?></b> • Sponsor payout today: <b><?= rupiah($sponsorToday) ?></b>
          </div>
        </div>
        <div class="text-end">
          <div class="text-secondary small">Omzet Join Today</div>
          <div class="fs-2 fw-bold"><?= rupiah($omzetToday) ?></div>
          <div class="small text-secondary">Pins unused: <b><?= (int)$pinsUnused ?></b></div>
        </div>
      </div>
    </div>
  </div>

  <!-- KPIs -->
  <div class="col-12 col-md-6 col-xl-3">
    <div class="kpi-card card">
      <div class="card-body d-flex justify-content-between align-items-center">
        <div>
          <div class="text-secondary small">Total Members</div>
          <div class="fs-4 fw-bold"><?= (int)$totalMembers ?></div>
          <div class="small text-secondary">Active: <b><?= (int)$activeMembers ?></b></div>
        </div>
        <div class="kpi-icon"><i class="bi bi-people fs-4"></i></div>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-6 col-xl-3">
    <div class="kpi-card card">
      <div class="card-body d-flex justify-content-between align-items-center">
        <div>
          <div class="text-secondary small">Pending WD</div>
          <div class="fs-4 fw-bold"><?= (int)$wdPendingCnt ?></div>
          <div class="small text-secondary"><?= rupiah($wdPendingAmt) ?></div>
        </div>
        <div class="kpi-icon"><i class="bi bi-cash-coin fs-4"></i></div>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-6 col-xl-3">
    <div class="kpi-card card">
      <div class="card-body d-flex justify-content-between align-items-center">
        <div>
          <div class="text-secondary small">Pins Unused</div>
          <div class="fs-4 fw-bold"><?= (int)$pinsUnused ?></div>
          <div class="small text-secondary">Activation pins</div>
        </div>
        <div class="kpi-icon"><i class="bi bi-key fs-4"></i></div>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-6 col-xl-3">
    <div class="kpi-card card">
      <div class="card-body d-flex justify-content-between align-items-center">
        <div>
          <div class="text-secondary small">Join Today</div>
          <div class="fs-4 fw-bold"><?= (int)$joinToday ?></div>
          <div class="small text-secondary">New members</div>
        </div>
        <div class="kpi-icon"><i class="bi bi-person-plus fs-4"></i></div>
      </div>
    </div>
  </div>

  <!-- Chart + Lists -->
  <div class="col-12 col-lg-7">
    <div class="soft-card card h-100">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="mb-0">Omzet Join (Last 7 Days)</h6>
          <a class="small text-decoration-none" href="/jwdnetwork/admin.php?page=reports">Reports</a>
        </div>
        <canvas id="omzet7" height="110"></canvas>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-5">
    <div class="soft-card card h-100">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="mb-0">Latest Withdrawals</h6>
          <a class="small text-decoration-none" href="/jwdnetwork/admin.php?page=withdrawals">Open</a>
        </div>

        <div class="table-responsive">
          <table class="table table-sm align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>ID</th><th>User</th><th class="text-end">Amount</th><th>Status</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($lastWd)): ?>
                <tr><td colspan="4" class="text-center text-secondary py-3">No data.</td></tr>
              <?php else: foreach ($lastWd as $r): ?>
                <tr>
                  <td class="fw-semibold">#<?= (int)$r['id'] ?></td>
                  <td><?= e($r['username']) ?></td>
                  <td class="text-end fw-bold"><?= rupiah($r['amount']) ?></td>
                  <td>
                    <?php
                      $stt=$r['status'];
                      $cls = $stt==='approved'?'success':($stt==='rejected'?'danger':'warning');
                    ?>
                    <span class="badge bg-<?= $cls ?>"><?= e(strtoupper($stt)) ?></span>
                  </td>
                </tr>
              <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>

      </div>
    </div>
  </div>

  <div class="col-12">
    <div class="soft-card card">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="mb-0">Latest Transactions</h6>
          <a class="small text-decoration-none" href="/jwdnetwork/admin.php?page=reports">View all</a>
        </div>

        <div class="table-responsive">
          <table class="table table-sm align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th style="width:150px">Tanggal</th>
                <th style="width:120px">User</th>
                <th style="width:120px">Type</th>
                <th>Desc</th>
                <th class="text-end" style="width:160px">Amount</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($lastTx)): ?>
                <tr><td colspan="5" class="text-center text-secondary py-3">No data.</td></tr>
              <?php else: foreach ($lastTx as $t): ?>
                <tr>
                  <td class="small text-secondary"><?= e($t['created_at']) ?></td>
                  <td class="fw-semibold"><?= e($t['username']) ?></td>
                  <td><span class="badge bg-dark"><?= e(strtoupper($t['tx_type'])) ?></span></td>
                  <td class="small"><?= e($t['description'] ?: '-') ?></td>
                  <td class="text-end fw-bold <?= ((float)$t['amount']<0)?'text-danger':'' ?>"><?= rupiah($t['amount']) ?></td>
                </tr>
              <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>

      </div>
    </div>
  </div>

</div>

<!-- Chart.js (CDN) -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const labels = <?= json_encode($days) ?>;
const data = <?= json_encode($amts) ?>;
new Chart(document.getElementById('omzet7'), {
  type: 'line',
  data: {
    labels,
    datasets: [{ label: 'Omzet', data, tension: 0.35 }]
  },
  options: {
    responsive: true,
    plugins: { legend: { display: false } },
    scales: {
      y: { ticks: { callback: (v)=> 'Rp ' + v.toLocaleString('id-ID') } }
    }
  }
});
</script>
