<?php
$pdo = Db::pdo();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) { echo '<div class="alert alert-danger">ID tidak valid.</div>'; return; }

$msg = null; $err = null;

function cleanPhone($s){ return preg_replace('/[^0-9+]/','', trim((string)$s)); }
function cleanAccount($s){ return preg_replace('/[^0-9]/','', trim((string)$s)); }

// ambil data member
$st = $pdo->prepare("
  SELECT id, username, full_name, phone, email, address, bank_name, bank_account
  FROM members
  WHERE id=? LIMIT 1
");
$st->execute([$id]);
$m = $st->fetch();
if (!$m) { echo '<div class="alert alert-danger">Member tidak ditemukan.</div>'; return; }

$val = [
  'full_name' => (string)($m['full_name'] ?? ''),
  'phone' => (string)($m['phone'] ?? ''),
  'email' => (string)($m['email'] ?? ''),
  'address' => (string)($m['address'] ?? ''),
  'bank_name' => (string)($m['bank_name'] ?? ''),
  'bank_account' => (string)($m['bank_account'] ?? ''),
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? 'save';

  if ($action === 'save') {
    $val['full_name'] = trim($_POST['full_name'] ?? '');
    $val['phone'] = cleanPhone($_POST['phone'] ?? '');
    $val['email'] = trim($_POST['email'] ?? '');
    $val['address'] = trim($_POST['address'] ?? '');
    $val['bank_name'] = trim($_POST['bank_name'] ?? '');
    $val['bank_account'] = cleanAccount($_POST['bank_account'] ?? '');

    if ($val['full_name'] === '') $err = "Nama lengkap wajib diisi.";
    elseif ($val['phone'] === '') $err = "No. HP wajib diisi.";
    elseif ($val['email'] !== '' && !filter_var($val['email'], FILTER_VALIDATE_EMAIL)) $err = "Format email tidak valid.";
    elseif ($val['bank_account'] !== '' && strlen($val['bank_account']) < 6) $err = "No rekening terlalu pendek.";

    // email unik
    if (!$err && $val['email'] !== '') {
      $st = $pdo->prepare("SELECT id FROM members WHERE email=? AND id<>? LIMIT 1");
      $st->execute([$val['email'], $id]);
      if ($st->fetch()) $err = "Email sudah dipakai member lain.";
    }

    if (!$err) {
      $pdo->prepare("
        UPDATE members
        SET full_name=?, phone=?, email=?, address=?, bank_name=?, bank_account=?, updated_at=NOW()
        WHERE id=?
      ")->execute([
        $val['full_name'],
        $val['phone'],
        $val['email'] !== '' ? $val['email'] : null,
        $val['address'] !== '' ? $val['address'] : null,
        $val['bank_name'] !== '' ? $val['bank_name'] : null,
        $val['bank_account'] !== '' ? $val['bank_account'] : null,
        $id
      ]);
      $msg = "Data profile berhasil disimpan.";
    }
  }

  if ($action === 'reset_password') {
    $newPass = (string)($_POST['new_password'] ?? '');
    $newPass2 = (string)($_POST['new_password2'] ?? '');

    if ($newPass === '' || $newPass2 === '') $err = "Password baru wajib diisi.";
    elseif ($newPass !== $newPass2) $err = "Konfirmasi password tidak sama.";
    elseif (strlen($newPass) < 6) $err = "Password minimal 6 karakter.";

    if (!$err) {
      $hash = password_hash($newPass, PASSWORD_BCRYPT);
      $pdo->prepare("UPDATE members SET password_hash=?, updated_at=NOW() WHERE id=?")->execute([$hash, $id]);
      $msg = "Password berhasil direset.";
    }
  }
}
?>

<div class="d-flex flex-wrap justify-content-between align-items-center gap-2 mb-3">
  <div>
    <h4 class="mb-0">Edit Member</h4>
    <div class="text-secondary small">Username: <b><?= e($m['username']) ?></b> • ID: <?= (int)$id ?></div>
  </div>
  <a class="btn btn-outline-secondary btn-sm" href="/jwdnetwork/admin.php?page=members">
    <i class="bi bi-arrow-left me-1"></i> Kembali
  </a>
</div>

<?php if ($msg): ?><div class="alert alert-success"><?= e($msg) ?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-danger"><?= e($err) ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-12 col-lg-7">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-3">Profile & Data Bank</h6>

        <form method="post" class="row g-2" autocomplete="off">
          <input type="hidden" name="action" value="save">

          <div class="col-12">
            <label class="form-label mb-1">Nama lengkap (sesuai data Bank) <span class="text-danger">*</span></label>
            <input class="form-control" name="full_name" required value="<?= e($val['full_name']) ?>">
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label mb-1">No. HP <span class="text-danger">*</span></label>
            <input class="form-control" name="phone" required value="<?= e($val['phone']) ?>">
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label mb-1">Email</label>
            <input type="email" class="form-control" name="email" value="<?= e($val['email']) ?>">
          </div>

          <div class="col-12">
            <label class="form-label mb-1">Alamat</label>
            <textarea class="form-control" name="address" rows="3"><?= e($val['address']) ?></textarea>
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label mb-1">Bank</label>
            <input class="form-control" name="bank_name" value="<?= e($val['bank_name']) ?>" placeholder="BCA / BRI / Mandiri / dll">
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label mb-1">No. Rekening</label>
            <input class="form-control" name="bank_account" value="<?= e($val['bank_account']) ?>" placeholder="Hanya angka">
          </div>

          <div class="col-12 mt-2">
            <button class="btn btn-primary w-100">
              <i class="bi bi-save me-1"></i> Simpan
            </button>
          </div>
        </form>

      </div>
    </div>
  </div>

  <div class="col-12 col-lg-5">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-3">Reset Password</h6>

        <form method="post" class="row g-2" autocomplete="off">
          <input type="hidden" name="action" value="reset_password">

          <div class="col-12">
            <label class="form-label mb-1">Password Baru</label>
            <input type="password" class="form-control" name="new_password" minlength="6" required>
          </div>

          <div class="col-12">
            <label class="form-label mb-1">Ulangi Password</label>
            <input type="password" class="form-control" name="new_password2" minlength="6" required>
          </div>

          <div class="col-12 mt-2">
            <button class="btn btn-danger w-100">
              <i class="bi bi-shield-lock me-1"></i> Reset Password
            </button>
          </div>
          

          <div class="col-12">
            <div class="small text-secondary">
              Minimal 6 karakter. Setelah reset, member login pakai password baru.
            </div>
          </div>
        </form>

      </div>
    </div>

    <div class="card border-0 shadow-sm mt-3">
      <div class="card-body">
        <h6 class="mb-2">Info</h6>
        <ul class="mb-0 small text-secondary">
          <li>Nama harus sesuai rekening untuk proses withdraw.</li>
          <li>Email dibuat unik (jika diisi).</li>
          <li>Upline diambil dari <code>binary_placements.parent_id</code>.</li>
        </ul>
      </div>
    </div>
  </div>
</div>
