<?php
$pdo = Db::pdo();

// pagination sederhana
$perPage = 25;
$pageNum = isset($_GET['p']) ? (int)$_GET['p'] : 1;
if ($pageNum < 1) $pageNum = 1;
$offset = ($pageNum - 1) * $perPage;

// total
$total = (int)$pdo->query("SELECT COUNT(*) c FROM members WHERE role='member'")->fetch()['c'];
$totalPages = max(1, (int)ceil($total / $perPage));

// list member + package + sponsor + upline(parent placement)
$st = $pdo->prepare("
  SELECT
    m.id,
    m.username,
    m.full_name,
    m.created_at,
    p.code AS package_code,
    s.username AS sponsor_username,
    up.username AS upline_username
  FROM members m
  LEFT JOIN packages p ON p.id = m.package_id
  LEFT JOIN members s ON s.id = m.sponsor_id
  LEFT JOIN binary_placements bp ON bp.member_id = m.id
  LEFT JOIN members up ON up.id = bp.parent_id
  WHERE m.role='member'
  ORDER BY m.id DESC
  LIMIT {$perPage} OFFSET {$offset}
");
$st->execute();
$rows = $st->fetchAll();

function members_url($p) {
  return '/jwdnetwork/admin.php?page=members&p='.(int)$p;
}
?>

<div class="d-flex flex-wrap justify-content-between align-items-center gap-2 mb-3">
  <div>
    <h4 class="mb-0">Members</h4>
    <div class="text-secondary small">Total: <b><?= number_format($total) ?></b></div>
  </div>
</div>

<div class="card border-0 shadow-sm">
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>Username</th>
            <th>Package</th>
            <th>Nama</th>
            <th>Sponsor</th>
            <th>Upline</th>
            <th>Date Join</th>
            <th style="width:90px;" class="text-end">Edit</th>
          </tr>
        </thead>
        <tbody>
          <?php if (empty($rows)): ?>
            <tr><td colspan="7" class="text-center text-secondary py-4">Belum ada member.</td></tr>
          <?php else: ?>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td class="fw-semibold"><?= e($r['username']) ?></td>
                <td><span class="badge bg-dark"><?= e($r['package_code'] ?: '-') ?></span></td>
                <td><?= e($r['full_name'] ?: '-') ?></td>
                <td><?= e($r['sponsor_username'] ?: '-') ?></td>
                <td><?= e($r['upline_username'] ?: '-') ?></td>
                <td class="small text-secondary"><?= e($r['created_at']) ?></td>
                <td class="text-end">
                  <a class="btn btn-sm btn-primary"
                     href="/jwdnetwork/admin.php?page=member_edit&id=<?= (int)$r['id'] ?>">
                    <i class="bi bi-pencil-square"></i>
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <?php if ($totalPages > 1): ?>
    <div class="card-footer bg-white">
      <ul class="pagination mb-0 flex-wrap">
        <li class="page-item <?= $pageNum<=1?'disabled':'' ?>">
          <a class="page-link" href="<?= members_url(1) ?>">&laquo;</a>
        </li>
        <li class="page-item <?= $pageNum<=1?'disabled':'' ?>">
          <a class="page-link" href="<?= members_url($pageNum-1) ?>">&lsaquo;</a>
        </li>

        <?php
          $start = max(1, $pageNum-2);
          $end = min($totalPages, $pageNum+2);
          for ($i=$start; $i<=$end; $i++):
        ?>
          <li class="page-item <?= $i===$pageNum?'active':'' ?>">
            <a class="page-link" href="<?= members_url($i) ?>"><?= $i ?></a>
          </li>
        <?php endfor; ?>

        <li class="page-item <?= $pageNum>=$totalPages?'disabled':'' ?>">
          <a class="page-link" href="<?= members_url($pageNum+1) ?>">&rsaquo;</a>
        </li>
        <li class="page-item <?= $pageNum>=$totalPages?'disabled':'' ?>">
          <a class="page-link" href="<?= members_url($totalPages) ?>">&raquo;</a>
        </li>
      </ul>
    </div>
  <?php endif; ?>
</div>
