<?php
$pdo = Db::pdo();
$msg = null; $err = null;

$packages = $pdo->query("SELECT id, code, price FROM packages ORDER BY id")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pkgId = (int)($_POST['package_id'] ?? 0);
  $qty = (int)($_POST['qty'] ?? 1);
  if ($qty < 1) $qty = 1;
  if ($qty > 200) $qty = 200;

  $assignUser = trim($_POST['assign_username'] ?? '');
  $note = trim($_POST['note'] ?? '');

  $st = $pdo->prepare("SELECT id, code FROM packages WHERE id=? LIMIT 1");
  $st->execute([$pkgId]);
  $pkg = $st->fetch();
  if (!$pkg) {
    $err = "Paket tidak valid.";
  } else {
    $assignMemberId = null;
    if ($assignUser !== '') {
      $st = $pdo->prepare("SELECT id FROM members WHERE username=? AND role='member' LIMIT 1");
      $st->execute([$assignUser]);
      $m = $st->fetch();
      if (!$m) $err = "Username member tujuan tidak ditemukan.";
      else $assignMemberId = (int)$m['id'];
    }
  }

  if (!$err) {
    $pdo->beginTransaction();
    try {
      $pins = [];
      for ($i=0; $i<$qty; $i++) {
        $pin = 'PIN-' . $pkg['code'] . '-' . strtoupper(bin2hex(random_bytes(4)));

        $st = $pdo->prepare("
          INSERT INTO pins_activation (pin_code, package_id, status, assigned_to_member_id, assigned_note, assigned_at)
          VALUES (?, ?, 'unused', ?, ?, ?)
        ");
        $st->execute([
          $pin,
          (int)$pkg['id'],
          $assignMemberId,
          $note ?: null,
          ($assignMemberId ? date('Y-m-d H:i:s') : null)
        ]);

        $pins[] = $pin;
      }

      $pdo->commit();
      $msg = "Berhasil generate {$qty} PIN ({$pkg['code']}).";
      $_POST['generated_pins'] = $pins;

    } catch (Throwable $e) {
      if ($pdo->inTransaction()) $pdo->rollBack();
      $err = $e->getMessage();
    }
  }
}

$list = $pdo->query("
  SELECT p.pin_code, p.status, p.assigned_at, p.assigned_note, p.created_at,
         pk.code AS package_code,
         m.username AS assigned_username
  FROM pins_activation p
  JOIN packages pk ON pk.id = p.package_id
  LEFT JOIN members m ON m.id = p.assigned_to_member_id
  ORDER BY p.id DESC
  LIMIT 50
")->fetchAll();
?>

<div class="row g-3">
  <div class="col-12">
    <h4 class="mb-0">PIN Aktivasi</h4>
    <div class="text-secondary">Generate PIN dan assign ke member (copy pin untuk dikirim manual).</div>
  </div>

  <div class="col-12">
    <?php if ($msg): ?><div class="alert alert-success"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-danger"><?= e($err) ?></div><?php endif; ?>
  </div>

  <div class="col-12 col-lg-5">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-3">Generate & Kirim PIN</h6>

        <form method="post" class="row g-2">
          <div class="col-12">
            <label class="form-label mb-1">Paket</label>
            <select class="form-select" name="package_id" required>
              <?php foreach ($packages as $p): ?>
                <option value="<?= (int)$p['id'] ?>">
                  <?= e($p['code']) ?> (Rp <?= number_format((float)$p['price'],0,',','.') ?>)
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-12 col-md-4">
            <label class="form-label mb-1">Qty</label>
            <input type="number" class="form-control" name="qty" value="1" min="1" max="200">
          </div>

          <div class="col-12 col-md-8">
            <label class="form-label mb-1">Username Member (opsional)</label>
            <input class="form-control" name="assign_username" placeholder="contoh: m2" value="<?= e($_POST['assign_username'] ?? '') ?>">
          </div>

          <div class="col-12">
            <label class="form-label mb-1">Catatan (opsional)</label>
            <input class="form-control" name="note" placeholder="misal: PIN untuk join" value="<?= e($_POST['note'] ?? '') ?>">
          </div>

          <div class="col-12">
            <button class="btn btn-dark w-100">
              <i class="bi bi-magic me-1"></i> Generate PIN
            </button>
          </div>
        </form>

        <?php if (!empty($_POST['generated_pins'])): ?>
          <hr>
          <div class="small text-secondary mb-2">PIN baru (klik copy):</div>
          <?php foreach ($_POST['generated_pins'] as $pin): ?>
            <div class="d-flex align-items-center justify-content-between border rounded-3 p-2 mb-2">
              <code class="mb-0"><?= e($pin) ?></code>
              <button class="btn btn-outline-primary btn-sm" type="button" data-copy="<?= e($pin) ?>">
                <i class="bi bi-clipboard"></i>
              </button>
            </div>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-7">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-3">PIN Terbaru (50)</h6>
        <div class="table-responsive">
          <table class="table table-sm align-middle">
            <thead class="table-light">
              <tr>
                <th>PIN</th>
                <th>Paket</th>
                <th>Status</th>
                <th>Assigned</th>
                <th style="width:60px;"></th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($list as $r): ?>
                <tr>
                  <td><code><?= e($r['pin_code']) ?></code></td>
                  <td><?= e($r['package_code']) ?></td>
                  <td>
                    <span class="badge <?= $r['status']==='unused'?'bg-success':'bg-secondary' ?>">
                      <?= e(strtoupper($r['status'])) ?>
                    </span>
                  </td>
                  <td class="small">
                    <?php if (!empty($r['assigned_username'])): ?>
                      <div><b><?= e($r['assigned_username']) ?></b></div>
                      <?php if (!empty($r['assigned_note'])): ?>
                        <div class="text-secondary"><?= e($r['assigned_note']) ?></div>
                      <?php endif; ?>
                    <?php else: ?>
                      <span class="text-secondary">-</span>
                    <?php endif; ?>
                  </td>
                  <td class="text-end">
                    <button class="btn btn-outline-primary btn-sm" type="button" data-copy="<?= e($r['pin_code']) ?>">
                      <i class="bi bi-clipboard"></i>
                    </button>
                  </td>
                </tr>
              <?php endforeach; ?>
              <?php if (empty($list)): ?>
                <tr><td colspan="5" class="text-center text-secondary py-3">Belum ada PIN.</td></tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
        <div class="text-secondary small">Klik clipboard untuk copy PIN.</div>
      </div>
    </div>
  </div>
</div>
