<?php
$pdo = Db::pdo();

$perPage = 25;
$pageNum = isset($_GET['p']) ? (int)$_GET['p'] : 1;
if ($pageNum < 1) $pageNum = 1;

$tx = strtolower(trim($_GET['tx'] ?? ''));
$userQ = trim($_GET['user'] ?? '');
$dateFrom = trim($_GET['from'] ?? ''); // YYYY-MM-DD
$dateTo   = trim($_GET['to'] ?? '');   // YYYY-MM-DD

$allowedTx = ['','sponsor','matching','daily','reward','royalty','withdraw','adjust','pairing'];
if (!in_array($tx, $allowedTx, true)) $tx = '';

$where = "1=1";
$params = [];

if ($tx !== '') {
  $where .= " AND LOWER(w.tx_type)=?";
  $params[] = $tx;
}
if ($userQ !== '') {
  $where .= " AND m.username LIKE ?";
  $params[] = "%{$userQ}%";
}
if ($dateFrom !== '') {
  $where .= " AND w.created_at >= ?";
  $params[] = $dateFrom . " 00:00:00";
}
if ($dateTo !== '') {
  $where .= " AND w.created_at <= ?";
  $params[] = $dateTo . " 23:59:59";
}

// total rows
$st = $pdo->prepare("
  SELECT COUNT(*) AS c
  FROM wallet_transactions w
  JOIN members m ON m.id = w.member_id
  WHERE {$where}
");
$st->execute($params);
$totalRows = (int)$st->fetch()['c'];

$totalPages = max(1, (int)ceil($totalRows / $perPage));
if ($pageNum > $totalPages) $pageNum = $totalPages;

$offset = ($pageNum - 1) * $perPage;

// summary IN/OUT/NET
$st = $pdo->prepare("
  SELECT
    COALESCE(SUM(CASE WHEN w.amount > 0 THEN w.amount ELSE 0 END), 0) AS total_in,
    COALESCE(SUM(CASE WHEN w.amount < 0 THEN -w.amount ELSE 0 END), 0) AS total_out,
    COALESCE(SUM(w.amount), 0) AS net
  FROM wallet_transactions w
  JOIN members m ON m.id = w.member_id
  WHERE {$where}
");
$st->execute($params);
$sum = $st->fetch();
$totalIn = (float)$sum['total_in'];
$totalOut = (float)$sum['total_out'];
$net = (float)$sum['net'];

// rows
$sql = "
  SELECT
    w.id, w.created_at, w.tx_type, w.amount, w.description, w.ref_table, w.ref_id,
    m.username
  FROM wallet_transactions w
  JOIN members m ON m.id = w.member_id
  WHERE {$where}
  ORDER BY w.id DESC
  LIMIT {$perPage} OFFSET {$offset}
";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

function rupiah($n){ return 'Rp ' . number_format((float)$n, 0, ',', '.'); }

function badge_tx($type) {
  $type = strtolower((string)$type);
  $map = [
    'sponsor' => 'primary',
    'matching' => 'success',
    'pairing' => 'success',
    'daily' => 'warning',
    'reward' => 'info',
    'royalty' => 'secondary',
    'withdraw' => 'danger',
    'adjust' => 'dark',
  ];
  $cls = $map[$type] ?? 'light';
  return '<span class="badge bg-'.$cls.'">'.e(strtoupper($type)).'</span>';
}

$txLabels = [
  '' => 'Semua',
  'sponsor' => 'Sponsor',
  'pairing' => 'Pairing',
  'matching' => 'Matching',
  'daily' => 'Daily',
  'reward' => 'Reward',
  'royalty' => 'Royalty',
  'withdraw' => 'Withdraw',
  'adjust' => 'Adjust',
];

function reports_url($p, $tx, $user, $from, $to) {
  $q = '/jwdnetwork/admin.php?page=reports&p='.(int)$p;
  if ($tx !== '') $q .= '&tx='.urlencode($tx);
  if ($user !== '') $q .= '&user='.urlencode($user);
  if ($from !== '') $q .= '&from='.urlencode($from);
  if ($to !== '') $q .= '&to='.urlencode($to);
  return $q;
}
?>

<div class="d-flex flex-wrap justify-content-between align-items-center gap-2 mb-3">
  <div>
    <h4 class="mb-0">Reports</h4>
    <div class="text-secondary small">Wallet Transactions (<?= number_format($totalRows) ?> data)</div>
  </div>
</div>

<!-- Filters -->
<div class="card border-0 shadow-sm mb-3">
  <div class="card-body">
    <form class="row g-2 align-items-end" method="get" action="/jwdnetwork/admin.php">
      <input type="hidden" name="page" value="reports">
      <input type="hidden" name="p" value="1">

      <div class="col-12 col-md-2">
        <label class="form-label mb-1">From</label>
        <input type="date" class="form-control" name="from" value="<?= e($dateFrom) ?>">
      </div>

      <div class="col-12 col-md-2">
        <label class="form-label mb-1">To</label>
        <input type="date" class="form-control" name="to" value="<?= e($dateTo) ?>">
      </div>

      <div class="col-12 col-md-2">
        <label class="form-label mb-1">Tx Type</label>
        <select class="form-select" name="tx">
          <?php foreach ($txLabels as $k => $label): ?>
            <option value="<?= e($k) ?>" <?= $k === $tx ? 'selected' : '' ?>><?= e($label) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label mb-1">Username</label>
        <input class="form-control" name="user" value="<?= e($userQ) ?>" placeholder="Cari username...">
      </div>

      <div class="col-12 col-md-3 d-flex gap-2">
        <button class="btn btn-primary" type="submit">
          <i class="bi bi-funnel me-1"></i> Apply
        </button>
        <a class="btn btn-outline-secondary" href="/jwdnetwork/admin.php?page=reports">Reset</a>
      </div>
    </form>
  </div>
</div>

<!-- Summary -->
<div class="row g-3 mb-3">
  <div class="col-12 col-md-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="text-secondary small">Total IN</div>
        <div class="fs-5 fw-bold"><?= rupiah($totalIn) ?></div>
      </div>
    </div>
  </div>
  <div class="col-12 col-md-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="text-secondary small">Total OUT</div>
        <div class="fs-5 fw-bold"><?= rupiah($totalOut) ?></div>
      </div>
    </div>
  </div>
  <div class="col-12 col-md-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="text-secondary small">NET</div>
        <div class="fs-5 fw-bold"><?= rupiah($net) ?></div>
      </div>
    </div>
  </div>
</div>

<!-- Table -->
<div class="card border-0 shadow-sm">
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th style="width:170px;">Tanggal</th>
            <th style="width:130px;">Username</th>
            <th style="width:120px;">Type</th>
            <th style="width:170px;" class="text-end">Amount</th>
            <th>Deskripsi</th>
            <th style="width:160px;">Ref</th>
          </tr>
        </thead>
        <tbody>
          <?php if (empty($rows)): ?>
            <tr><td colspan="6" class="text-center text-secondary py-4">Tidak ada data.</td></tr>
          <?php else: ?>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td>
                  <div class="fw-semibold"><?= e(date('Y-m-d', strtotime($r['created_at']))) ?></div>
                  <div class="small text-secondary"><?= e(date('H:i:s', strtotime($r['created_at']))) ?></div>
                </td>
                <td class="fw-semibold"><?= e($r['username']) ?></td>
                <td><?= badge_tx($r['tx_type']) ?></td>
                <td class="text-end fw-bold">
                  <?php
                    $amt = (float)$r['amount'];
                    echo $amt >= 0 ? rupiah($amt) : '<span class="text-danger">'.rupiah($amt).'</span>';
                  ?>
                </td>
                <td>
                  <div class="small text-secondary">#<?= (int)$r['id'] ?></div>
                  <div><?= e($r['description'] ?: '-') ?></div>
                </td>
                <td class="small">
                  <?php if (!empty($r['ref_table'])): ?>
                    <div><?= e($r['ref_table']) ?></div>
                    <div class="text-secondary">ID: <?= e($r['ref_id']) ?></div>
                  <?php else: ?>
                    <span class="text-secondary">-</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <?php if ($totalPages > 1): ?>
    <div class="card-footer bg-white">
      <ul class="pagination mb-0 flex-wrap">
        <li class="page-item <?= $pageNum<=1?'disabled':'' ?>">
          <a class="page-link" href="<?= reports_url(1,$tx,$userQ,$dateFrom,$dateTo) ?>">&laquo;</a>
        </li>
        <li class="page-item <?= $pageNum<=1?'disabled':'' ?>">
          <a class="page-link" href="<?= reports_url($pageNum-1,$tx,$userQ,$dateFrom,$dateTo) ?>">&lsaquo;</a>
        </li>

        <?php
          $start = max(1, $pageNum-2);
          $end = min($totalPages, $pageNum+2);
          if ($start > 1) echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
          for ($i=$start; $i<=$end; $i++):
        ?>
          <li class="page-item <?= $i===$pageNum?'active':'' ?>">
            <a class="page-link" href="<?= reports_url($i,$tx,$userQ,$dateFrom,$dateTo) ?>"><?= $i ?></a>
          </li>
        <?php endfor;
          if ($end < $totalPages) echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
        ?>

        <li class="page-item <?= $pageNum>=$totalPages?'disabled':'' ?>">
          <a class="page-link" href="<?= reports_url($pageNum+1,$tx,$userQ,$dateFrom,$dateTo) ?>">&rsaquo;</a>
        </li>
        <li class="page-item <?= $pageNum>=$totalPages?'disabled':'' ?>">
          <a class="page-link" href="<?= reports_url($totalPages,$tx,$userQ,$dateFrom,$dateTo) ?>">&raquo;</a>
        </li>
      </ul>
    </div>
  <?php endif; ?>
</div>
