<?php
$pdo = Db::pdo();

$msg=null; $err=null;

$status = strtolower(trim($_GET['status'] ?? 'pending'));
if (!in_array($status, ['pending','approved','rejected','all'], true)) $status='pending';

$perPage = 25;
$pageNum = isset($_GET['p']) ? (int)$_GET['p'] : 1;
if ($pageNum < 1) $pageNum = 1;

$where = "1=1";
$params = [];
if ($status !== 'all') {
  $where .= " AND w.status=?";
  $params[] = $status;
}

function rupiah($n){ return 'Rp ' . number_format((float)$n, 0, ',', '.'); }
function wd_url($p,$status){
  return '/jwdnetwork/admin.php?page=withdrawals&status='.urlencode($status).'&p='.(int)$p;
}

// handle approve/reject
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $action = $_POST['action'] ?? '';
  $wdId = (int)($_POST['wd_id'] ?? 0);
  $note = trim($_POST['note'] ?? '');

  if ($wdId <= 0) $err = "ID WD tidak valid.";
  elseif (!in_array($action, ['approve','reject'], true)) $err = "Action tidak valid.";

  if (!$err) {
    try {
      $pdo->beginTransaction();

      // lock request
      $st = $pdo->prepare("SELECT * FROM withdraw_requests WHERE id=? LIMIT 1 FOR UPDATE");
      $st->execute([$wdId]);
      $wd = $st->fetch();
      if (!$wd) throw new Exception("WD tidak ditemukan.");
      if ($wd['status'] !== 'pending') throw new Exception("WD sudah diproses.");

      $memberId = (int)$wd['member_id'];
      $amount = (float)$wd['amount'];

      if ($action === 'approve') {
        $pdo->prepare("
          UPDATE withdraw_requests
          SET status='approved', note=?, processed_at=NOW(), processed_by=?
          WHERE id=?
        ")->execute([$note !== '' ? $note : null, (int)($_SESSION['auth']['id'] ?? 0), $wdId]);

        $msg = "WD #{$wdId} approved.";
      }

      if ($action === 'reject') {
        // refund saldo (karena waktu request saldo sudah dipotong)
        $st = $pdo->prepare("SELECT member_id FROM wallets WHERE member_id=? LIMIT 1 FOR UPDATE");
        $st->execute([$memberId]);
        if (!$st->fetch()) {
          $pdo->prepare("INSERT INTO wallets (member_id, balance) VALUES (?, 0.00)")->execute([$memberId]);
        }

        $pdo->prepare("UPDATE wallets SET balance = balance + ? WHERE member_id=?")
            ->execute([$amount, $memberId]);

        $pdo->prepare("
          INSERT INTO wallet_transactions (member_id, tx_type, amount, description, ref_table, ref_id, created_at)
          VALUES (?, 'adjust', ?, ?, 'withdraw_requests', ?, NOW())
        ")->execute([
          $memberId,
          $amount,
          "Refund WD #{$wdId} (rejected)",
          $wdId
        ]);

        $pdo->prepare("
          UPDATE withdraw_requests
          SET status='rejected', note=?, processed_at=NOW(), processed_by=?
          WHERE id=?
        ")->execute([$note !== '' ? $note : 'Rejected', (int)($_SESSION['auth']['id'] ?? 0), $wdId]);

        $msg = "WD #{$wdId} rejected & refunded.";
      }

      $pdo->commit();
    } catch (Throwable $e) {
      if ($pdo->inTransaction()) $pdo->rollBack();
      $err = $e->getMessage();
    }
  }
}

// total + list
$st = $pdo->prepare("
  SELECT COUNT(*) c
  FROM withdraw_requests w
  JOIN members m ON m.id=w.member_id
  WHERE {$where}
");
$st->execute($params);
$totalRows = (int)$st->fetch()['c'];
$totalPages = max(1, (int)ceil($totalRows / $perPage));
if ($pageNum > $totalPages) $pageNum = $totalPages;
$offset = ($pageNum-1)*$perPage;

$st = $pdo->prepare("
  SELECT w.*, m.username
  FROM withdraw_requests w
  JOIN members m ON m.id=w.member_id
  WHERE {$where}
  ORDER BY w.id DESC
  LIMIT {$perPage} OFFSET {$offset}
");
$st->execute($params);
$rows = $st->fetchAll();
?>

<div class="d-flex flex-wrap justify-content-between align-items-center gap-2 mb-3">
  <div>
    <h4 class="mb-0">Withdrawals</h4>
    <div class="text-secondary small">Total: <b><?= number_format($totalRows) ?></b></div>
  </div>

  <form class="d-flex gap-2" method="get" action="/jwdnetwork/admin.php">
    <input type="hidden" name="page" value="withdrawals">
    <select class="form-select form-select-sm" name="status" onchange="this.form.submit()">
      <option value="pending" <?= $status==='pending'?'selected':'' ?>>Pending</option>
      <option value="approved" <?= $status==='approved'?'selected':'' ?>>Approved</option>
      <option value="rejected" <?= $status==='rejected'?'selected':'' ?>>Rejected</option>
      <option value="all" <?= $status==='all'?'selected':'' ?>>All</option>
    </select>
  </form>
</div>

<?php if ($msg): ?><div class="alert alert-success"><?= e($msg) ?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-danger"><?= e($err) ?></div><?php endif; ?>

<div class="card border-0 shadow-sm">
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th style="width:80px;">ID</th>
            <th style="width:140px;">User</th>
            <th style="width:170px;" class="text-end">Amount</th>
            <th style="width:220px;">Bank</th>
            <th style="width:160px;">Requested</th>
            <th style="width:120px;">Status</th>
            <th style="width:220px;">Action</th>
          </tr>
        </thead>
        <tbody>
          <?php if (empty($rows)): ?>
            <tr><td colspan="7" class="text-center text-secondary py-4">Tidak ada data.</td></tr>
          <?php else: foreach ($rows as $r): ?>
            <tr>
              <td class="fw-semibold">#<?= (int)$r['id'] ?></td>
              <td><?= e($r['username']) ?></td>
              <td class="text-end fw-bold"><?= rupiah($r['amount']) ?></td>
              <td class="small">
                <div class="fw-semibold"><?= e($r['bank_name'] ?: '-') ?></div>
                <div class="text-secondary"><?= e($r['bank_account'] ?: '-') ?> • <?= e($r['account_name'] ?: '-') ?></div>
              </td>
              <td class="small text-secondary"><?= e($r['requested_at']) ?></td>
              <td>
                <?php
                  $stt = $r['status'];
                  $cls = $stt==='approved' ? 'success' : ($stt==='rejected' ? 'danger' : 'warning');
                ?>
                <span class="badge bg-<?= $cls ?>"><?= e(strtoupper($stt)) ?></span>
              </td>
              <td>
                <?php if ($r['status']==='pending'): ?>
                  <form method="post" class="d-flex gap-2 flex-wrap">
                    <input type="hidden" name="wd_id" value="<?= (int)$r['id'] ?>">
                    <input type="text" name="note" class="form-control form-control-sm" placeholder="note (opsional)">
                    <button class="btn btn-sm btn-success" name="action" value="approve">
                      <i class="bi bi-check2"></i>
                    </button>
                    <button class="btn btn-sm btn-danger" name="action" value="reject">
                      <i class="bi bi-x"></i>
                    </button>
                  </form>
                <?php else: ?>
                  <div class="small text-secondary">
                    <?= e($r['processed_at'] ?: '-') ?><br>
                    Note: <?= e($r['note'] ?: '-') ?>
                  </div>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <?php if ($totalPages > 1): ?>
    <div class="card-footer bg-white">
      <ul class="pagination mb-0 flex-wrap">
        <li class="page-item <?= $pageNum<=1?'disabled':'' ?>"><a class="page-link" href="<?= wd_url(1,$status) ?>">&laquo;</a></li>
        <li class="page-item <?= $pageNum<=1?'disabled':'' ?>"><a class="page-link" href="<?= wd_url($pageNum-1,$status) ?>">&lsaquo;</a></li>
        <?php
          $start=max(1,$pageNum-2); $end=min($totalPages,$pageNum+2);
          if($start>1) echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
          for($i=$start;$i<=$end;$i++):
        ?>
          <li class="page-item <?= $i===$pageNum?'active':'' ?>"><a class="page-link" href="<?= wd_url($i,$status) ?>"><?= $i ?></a></li>
        <?php endfor;
          if($end<$totalPages) echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
        ?>
        <li class="page-item <?= $pageNum>=$totalPages?'disabled':'' ?>"><a class="page-link" href="<?= wd_url($pageNum+1,$status) ?>">&rsaquo;</a></li>
        <li class="page-item <?= $pageNum>=$totalPages?'disabled':'' ?>"><a class="page-link" href="<?= wd_url($totalPages,$status) ?>">&raquo;</a></li>
      </ul>
    </div>
  <?php endif; ?>
</div>
