<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin Login - JWD NETWORK</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
  <style>
    body { background:#0b1220; }
    .wrap { min-height:100vh; display:flex; align-items:center; }
    .card { border-radius:16px; border:0; }
    .form-control, .btn { border-radius:12px; }
  </style>
</head>
<body>
<div class="wrap">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-sm-10 col-md-7 col-lg-5">

        <div class="text-center mb-4">
          <span class="badge bg-warning text-dark px-3 py-2 fw-bold">ADMIN PANEL</span>
          <div class="text-white-50 mt-2">JWD NETWORK</div>
        </div>

        <div class="card shadow-lg">
          <div class="card-body p-4">
            <?php if (!empty($error)): ?>
              <div class="alert alert-danger"><?= e($error) ?></div>
            <?php endif; ?>

            <form method="post" autocomplete="off">
              <div class="mb-3">
                <label class="form-label">Username</label>
                <input class="form-control" name="username" value="<?= e($_POST['username'] ?? '') ?>">
              </div>

              <div class="mb-3">
                <label class="form-label">Password</label>
                <div class="input-group">
                  <input id="password" type="password" class="form-control" name="password">
                  <button class="btn btn-outline-secondary" type="button" id="togglePw">
                    <i class="bi bi-eye" id="eyeIcon"></i>
                  </button>
                </div>
              </div>

              <button class="btn btn-warning w-100" type="submit">
                <i class="bi bi-shield-lock me-1"></i> Login Admin
              </button>
            </form>
          </div>
        </div>

        <div class="text-center mt-3">
          <a class="text-white-50" href="/jwdnetwork/public/?r=login">← Login Member</a>
        </div>

      </div>
    </div>
  </div>
</div>

<script>
  (function(){
    const pw = document.getElementById('password');
    const btn = document.getElementById('togglePw');
    const icon = document.getElementById('eyeIcon');
    btn.addEventListener('click', function(){
      const show = pw.type === 'password';
      pw.type = show ? 'text' : 'password';
      icon.className = show ? 'bi bi-eye-slash' : 'bi bi-eye';
    });
  })();
</script>
</body>
</html>
