<?php
// app/views/auth/login.php
$flash = flash_get('success');
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Member Login - JWD NETWORK</title>

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons (untuk ikon mata) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

  <style>
    body { background: #0b1220; }
    .login-wrap { min-height: 100vh; display:flex; align-items:center; }
    .login-card { border: 0; border-radius: 16px; }
    .brand-badge { font-weight: 700; letter-spacing: .5px; }
    .form-control { border-radius: 12px; }
    .btn { border-radius: 12px; }
    .muted { color: rgba(255,255,255,.65); }
  </style>
</head>
<body>

<div class="login-wrap">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-sm-10 col-md-7 col-lg-5">

        <div class="text-center mb-4">
          <div class="badge bg-primary brand-badge px-3 py-2">JWD NETWORK</div>
          <div class="muted mt-2">Login Member</div>
        </div>
      <!--   <div class="text-secondary small text-center mb-2">
  Login untuk <b>Admin</b> dan <b>Member</b>
</div> -->


        <div class="card login-card shadow-lg">
          <div class="card-body p-4 p-md-4">

            <?php if (!empty($flash)): ?>
              <div class="alert alert-success"><?= e($flash) ?></div>
            <?php endif; ?>

            <?php if (!empty($error)): ?>
              <div class="alert alert-danger"><?= e($error) ?></div>
            <?php endif; ?>

            <form method="post" autocomplete="off">
              <div class="mb-3">
                <label class="form-label">Username</label>
                <input class="form-control" name="username" value="<?= e($_POST['username'] ?? '') ?>" placeholder="contoh: m2">
              </div>

              <div class="mb-3">
                <label class="form-label">Password</label>
                <div class="input-group">
                  <input id="password" type="password" class="form-control" name="password" placeholder="••••••••">
                  <button class="btn btn-outline-secondary" type="button" id="togglePw" aria-label="Tampilkan password">
                    <i class="bi bi-eye" id="eyeIcon"></i>
                  </button>
                </div>
                <div class="form-text">Gunakan password akun member.</div>
              </div>

              <button class="btn btn-primary w-100 py-2" type="submit">
                <i class="bi bi-box-arrow-in-right me-1"></i> Masuk
              </button>
            </form>

          </div>
        </div>

        <div class="text-center mt-3 muted" style="font-size:.9rem">
          © <?= date('Y') ?> JWD NETWORK
        </div>

      </div>
    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  (function () {
    const pw = document.getElementById('password');
    const btn = document.getElementById('togglePw');
    const icon = document.getElementById('eyeIcon');

    btn.addEventListener('click', function () {
      const show = pw.type === 'password';
      pw.type = show ? 'text' : 'password';
      icon.className = show ? 'bi bi-eye-slash' : 'bi bi-eye';
    });
  })();
</script>
</body>
</html>
