<?php
// app/views/layouts/member.php
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Member Panel - JWD NETWORK</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
  <link href="/jwdnetwork/public/assets/css/member.css" rel="stylesheet">
</head>
<body>

<div class="member-shell">
  <!-- Sidebar (desktop) -->
  <aside class="sidebar d-none d-lg-flex">
    <?php require __DIR__ . '/../partials/member_sidebar.php'; ?>
    
  </aside>

  <!-- Main -->
  <main class="main">
    <!-- Topbar (member) -->
    <div class="topbar">
      <div class="d-flex align-items-center gap-2">
        <!-- Mobile sidebar button -->
        <button class="btn btn-dark d-lg-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#mobileSidebar">
          <i class="bi bi-list"></i>
        </button>
        <div class="fw-semibold">Member Panel</div>
      </div>

      <div class="d-flex align-items-center gap-2">
        <div class="small text-secondary d-none d-sm-block">
          Login: <b><?= e($member['username']) ?></b>
        </div>
        <a class="btn btn-outline-danger btn-sm" href="/jwdnetwork/public/?r=logout">
          <i class="bi bi-box-arrow-right me-1"></i> Logout
        </a>
      </div>
    </div>

    <div class="content p-3 p-lg-4">
      <?php
      if (is_file($viewFile)) {
        require $viewFile;
      } else {
        echo '<div class="alert alert-warning">Halaman tidak ditemukan.</div>';
      }
      ?>
    </div>
  </main>
</div>

<!-- Mobile Sidebar (offcanvas) -->
<div class="offcanvas offcanvas-start offcanvas-dark" tabindex="-1" id="mobileSidebar">
  <div class="offcanvas-header">
    <div class="d-flex align-items-center gap-2">
      <div class="brand-dot"></div>
      <div class="fw-bold">JWD NETWORK</div>
    </div>
    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body p-0">
    <?php require __DIR__ . '/../partials/member_sidebar.php'; ?>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="/jwdnetwork/public/assets/js/app.js"></script>
</body>
</html>
