<?php
$pdo = Db::pdo();
$msg = null; $err = null;

$authId = (int)($_SESSION['auth']['id'] ?? 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $old = (string)($_POST['old_password'] ?? '');
  $new = (string)($_POST['new_password'] ?? '');
  $new2 = (string)($_POST['new_password2'] ?? '');

  if (strlen($new) < 6) $err = "Password baru minimal 6 karakter.";
  elseif ($new !== $new2) $err = "Konfirmasi password baru tidak sama.";

  if (!$err) {
    $st = $pdo->prepare("SELECT id, password_hash FROM members WHERE id=? AND role='member' LIMIT 1");
    $st->execute([$authId]);
    $u = $st->fetch(PDO::FETCH_ASSOC);

    if (!$u) $err = "Akun member tidak ditemukan.";
    elseif (empty($u['password_hash'])) $err = "Password hash belum ada. Migrasi dulu.";
    elseif (!password_verify($old, $u['password_hash'])) $err = "Password lama salah.";
    else {
      $hash = password_hash($new, PASSWORD_DEFAULT);
      $st = $pdo->prepare("UPDATE members SET password_hash=? WHERE id=? LIMIT 1");
      $st->execute([$hash, $authId]);

      $msg = "Password berhasil diubah.";
      $_POST = [];
    }
  }
}
?>

<div class="row justify-content-center">
  <div class="col-12 col-lg-5">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h5 class="mb-1">Ganti Password</h5>
        <div class="text-secondary small mb-3">Gunakan password yang aman.</div>

        <?php if ($msg): ?><div class="alert alert-success"><?= e($msg) ?></div><?php endif; ?>
        <?php if ($err): ?><div class="alert alert-danger"><?= e($err) ?></div><?php endif; ?>

        <form method="post" autocomplete="off">
          <div class="mb-2">
            <label class="form-label">Password Lama</label>
            <div class="input-group">
              <input type="password" class="form-control pw" name="old_password" required>
              <button class="btn btn-outline-secondary btn-eye" type="button"><i class="bi bi-eye"></i></button>
            </div>
          </div>

          <div class="mb-2">
            <label class="form-label">Password Baru</label>
            <div class="input-group">
              <input type="password" class="form-control pw" name="new_password" required>
              <button class="btn btn-outline-secondary btn-eye" type="button"><i class="bi bi-eye"></i></button>
            </div>
          </div>

          <div class="mb-3">
            <label class="form-label">Konfirmasi Password Baru</label>
            <div class="input-group">
              <input type="password" class="form-control pw" name="new_password2" required>
              <button class="btn btn-outline-secondary btn-eye" type="button"><i class="bi bi-eye"></i></button>
            </div>
          </div>

          <button class="btn btn-dark w-100">
            <i class="bi bi-check2-circle me-1"></i> Simpan
          </button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('click', function(e){
  const btn = e.target.closest('.btn-eye');
  if(!btn) return;
  const wrap = btn.closest('.input-group');
  const input = wrap.querySelector('input.pw');
  const icon = btn.querySelector('i');

  if(input.type === 'password'){
    input.type = 'text';
    icon.classList.remove('bi-eye');
    icon.classList.add('bi-eye-slash');
  } else {
    input.type = 'password';
    icon.classList.remove('bi-eye-slash');
    icon.classList.add('bi-eye');
  }
});
</script>
