<?php
$pdo = Db::pdo();
$memberId = (int)$member['id'];

// wallet balance
$st = $pdo->prepare("SELECT balance FROM wallets WHERE member_id=? LIMIT 1");
$st->execute([$memberId]);
$balance = (float)($st->fetchColumn() ?: 0);

// direct sponsor count (langsung)
$st = $pdo->prepare("SELECT COUNT(*) FROM members WHERE sponsor_id=?");
$st->execute([$memberId]);
$directCnt = (int)$st->fetchColumn();

// active direct sponsor
$st = $pdo->prepare("SELECT COUNT(*) FROM members WHERE sponsor_id=? AND status='active'");
$st->execute([$memberId]);
$directActive = (int)$st->fetchColumn();

// pending WD
$st = $pdo->prepare("SELECT COUNT(*) FROM withdraw_requests WHERE member_id=? AND status='pending'");
$st->execute([$memberId]);
$wdPendingCnt = (int)$st->fetchColumn();

// sponsor bonus today
$st = $pdo->prepare("
  SELECT COALESCE(SUM(amount),0)
  FROM wallet_transactions
  WHERE member_id=? AND tx_type='sponsor' AND DATE(created_at)=CURDATE()
");
$st->execute([$memberId]);
$sponsorToday = (float)$st->fetchColumn();

// sponsor bonus this month
$st = $pdo->prepare("
  SELECT COALESCE(SUM(amount),0)
  FROM wallet_transactions
  WHERE member_id=? AND tx_type='sponsor'
    AND YEAR(created_at)=YEAR(CURDATE()) AND MONTH(created_at)=MONTH(CURDATE())
");
$st->execute([$memberId]);
$sponsorMonth = (float)$st->fetchColumn();

// network left/right count for ROOT member (total downline per leg)
$childOf = [];
$rows = $pdo->query("SELECT parent_id, leg, member_id FROM binary_placements")->fetchAll(PDO::FETCH_ASSOC);
foreach ($rows as $r) {
  $p = (int)$r['parent_id'];
  $leg = strtoupper($r['leg']);
  if (!isset($childOf[$p])) $childOf[$p] = ['L'=>0,'R'=>0];
  $childOf[$p][$leg] = (int)$r['member_id'];
}
$memo = [];
$countDesc = function($nodeId) use (&$countDesc, &$childOf, &$memo) {
  if ($nodeId<=0) return 0;
  if (isset($memo[$nodeId])) return $memo[$nodeId];
  $l = $childOf[$nodeId]['L'] ?? 0;
  $r = $childOf[$nodeId]['R'] ?? 0;
  $cnt = 0;
  if ($l>0) $cnt += 1 + $countDesc($l);
  if ($r>0) $cnt += 1 + $countDesc($r);
  return $memo[$nodeId] = $cnt;
};
$leftId  = $childOf[$memberId]['L'] ?? 0;
$rightId = $childOf[$memberId]['R'] ?? 0;
$leftCnt  = $leftId  ? (1 + $countDesc($leftId)) : 0;
$rightCnt = $rightId ? (1 + $countDesc($rightId)) : 0;

// last 8 transactions
$st = $pdo->prepare("
  SELECT tx_type, amount, description, created_at
  FROM wallet_transactions
  WHERE member_id=?
  ORDER BY id DESC
  LIMIT 8
");
$st->execute([$memberId]);
$lastTx = $st->fetchAll(PDO::FETCH_ASSOC);

function rupiah($n){ return 'Rp ' . number_format((float)$n, 0, ',', '.'); }
?>

<style>
.kpi-card{border:0;border-radius:16px;box-shadow:0 10px 30px rgba(0,0,0,.06)}
.kpi-icon{width:44px;height:44px;border-radius:14px;display:flex;align-items:center;justify-content:center;background:rgba(0,0,0,.06)}
.soft-card{border:0;border-radius:16px;box-shadow:0 10px 30px rgba(0,0,0,.06)}
</style>

<div class="row g-3">

  <div class="col-12">
    <div class="soft-card card">
      <div class="card-body d-flex flex-wrap justify-content-between align-items-center gap-3">
        <div>
          <div class="text-secondary small">Welcome back</div>
          <div class="fs-4 fw-bold mb-1"><?= e($member['username']) ?></div>
          <div class="small text-secondary">
            Sponsor Today: <b><?= rupiah($sponsorToday) ?></b> • This Month: <b><?= rupiah($sponsorMonth) ?></b>
          </div>
        </div>
        <div class="text-end">
          <div class="text-secondary small">Wallet Balance</div>
          <div class="fs-2 fw-bold"><?= rupiah($balance) ?></div>
          <div class="small text-secondary">Pending WD: <b><?= (int)$wdPendingCnt ?></b></div>
        </div>
      </div>
    </div>
  </div>

  <!-- KPI Cards -->
  <div class="col-12 col-md-6 col-xl-3">
    <div class="kpi-card card">
      <div class="card-body d-flex justify-content-between align-items-center">
        <div>
          <div class="text-secondary small">Sponsor Langsung</div>
          <div class="fs-4 fw-bold"><?= (int)$directCnt ?></div>
          <div class="small text-secondary">Active: <b><?= (int)$directActive ?></b></div>
        </div>
        <div class="kpi-icon"><i class="bi bi-people fs-4"></i></div>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-6 col-xl-3">
    <div class="kpi-card card">
      <div class="card-body d-flex justify-content-between align-items-center">
        <div>
          <div class="text-secondary small">Network Left</div>
          <div class="fs-4 fw-bold"><?= (int)$leftCnt ?></div>
          <div class="small text-secondary">Total downline</div>
        </div>
        <div class="kpi-icon"><i class="bi bi-diagram-3 fs-4"></i></div>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-6 col-xl-3">
    <div class="kpi-card card">
      <div class="card-body d-flex justify-content-between align-items-center">
        <div>
          <div class="text-secondary small">Network Right</div>
          <div class="fs-4 fw-bold"><?= (int)$rightCnt ?></div>
          <div class="small text-secondary">Total downline</div>
        </div>
        <div class="kpi-icon"><i class="bi bi-diagram-3-fill fs-4"></i></div>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-6 col-xl-3">
    <div class="kpi-card card">
      <div class="card-body d-flex justify-content-between align-items-center">
        <div>
          <div class="text-secondary small">Withdraw Pending</div>
          <div class="fs-4 fw-bold"><?= (int)$wdPendingCnt ?></div>
          <div class="small text-secondary">Menunggu admin</div>
        </div>
        <div class="kpi-icon"><i class="bi bi-cash-coin fs-4"></i></div>
      </div>
    </div>
  </div>

  <!-- Quick Actions + Recent Tx -->
  <div class="col-12 col-lg-4">
    <div class="soft-card card h-100">
      <div class="card-body">
        <h6 class="mb-3">Quick Actions</h6>
        <div class="d-grid gap-2">
          <a class="btn btn-dark" href="/jwdnetwork/member.php?page=register"><i class="bi bi-person-plus me-1"></i> Register Downline</a>
          <a class="btn btn-outline-dark" href="/jwdnetwork/member.php?page=network"><i class="bi bi-diagram-3 me-1"></i> View Network</a>
          <a class="btn btn-outline-dark" href="/jwdnetwork/member.php?page=wallet"><i class="bi bi-wallet2 me-1"></i> Wallet</a>
          <a class="btn btn-outline-dark" href="/jwdnetwork/member.php?page=withdraw"><i class="bi bi-send me-1"></i> Withdraw</a>
          <a class="btn btn-outline-dark" href="/jwdnetwork/member.php?page=sponsor"><i class="bi bi-people me-1"></i> Sponsor Langsung</a>
        </div>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-8">
    <div class="soft-card card h-100">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="mb-0">Recent Transactions</h6>
          <a class="small text-decoration-none" href="/jwdnetwork/member.php?page=reports">View all</a>
        </div>

        <div class="table-responsive">
          <table class="table table-sm align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th style="width:140px">Tanggal</th>
                <th style="width:110px">Type</th>
                <th>Deskripsi</th>
                <th class="text-end" style="width:160px">Amount</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($lastTx)): ?>
                <tr><td colspan="4" class="text-center text-secondary py-3">Belum ada transaksi.</td></tr>
              <?php else: foreach ($lastTx as $t): ?>
                <tr>
                  <td class="small text-secondary"><?= e($t['created_at']) ?></td>
                  <td><span class="badge bg-dark"><?= e(strtoupper($t['tx_type'])) ?></span></td>
                  <td class="small"><?= e($t['description'] ?: '-') ?></td>
                  <td class="text-end fw-bold <?= ((float)$t['amount']<0)?'text-danger':'' ?>">
                    <?= rupiah($t['amount']) ?>
                  </td>
                </tr>
              <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>

      </div>
    </div>
  </div>

</div>
