<?php
$pdo = Db::pdo();
$memberId = (int)($_SESSION['auth']['id'] ?? 0);

// filter
$status = trim($_GET['status'] ?? '');

// pagination
$perPage = 25;
$pageNum = (int)($_GET['p'] ?? 1);
if ($pageNum < 1) $pageNum = 1;
$offset = ($pageNum - 1) * $perPage;

$where = "p.assigned_to_member_id = ?";
$params = [$memberId];

if ($status === 'unused' || $status === 'used') {
  $where .= " AND p.status = ?";
  $params[] = $status;
}

// total rows
$st = $pdo->prepare("SELECT COUNT(*) FROM pins_activation p WHERE $where");
$st->execute($params);
$total = (int)$st->fetchColumn();
$totalPages = (int)ceil(max(1, $total) / $perPage);

// list
$sql = "
  SELECT p.pin_code, p.status, p.assigned_at, p.assigned_note, p.created_at,
         pk.code AS package_code, pk.price
  FROM pins_activation p
  JOIN packages pk ON pk.id = p.package_id
  WHERE $where
  ORDER BY p.id DESC
  LIMIT $perPage OFFSET $offset
";
$st = $pdo->prepare($sql);
$st->execute($params);
$list = $st->fetchAll();
?>

<div class="row g-3">
  <div class="col-12">
    <h4 class="mb-0">PIN Aktivasi Saya</h4>
    <div class="text-secondary">PIN yang dikirim admin ke akun kamu.</div>
  </div>

  <div class="col-12">
    <form class="row g-2" method="get" action="member.php">
      <input type="hidden" name="page" value="pins">
      <div class="col-12 col-md-4">
        <select name="status" class="form-select">
          <option value="">Semua Status</option>
          <option value="unused" <?= $status==='unused'?'selected':'' ?>>UNUSED</option>
          <option value="used" <?= $status==='used'?'selected':'' ?>>USED</option>
        </select>
      </div>
      <div class="col-12 col-md-3">
        <button class="btn btn-dark w-100">
          <i class="bi bi-funnel me-1"></i> Filter
        </button>
      </div>
    </form>
  </div>

  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-3">Daftar PIN (<?= (int)$total ?>)</h6>

        <div class="table-responsive">
          <table class="table table-sm align-middle">
            <thead class="table-light">
              <tr>
                <th>PIN</th>
                <th>Paket</th>
                <th>Status</th>
                <th>Catatan</th>
                <th>Assigned</th>
                <th style="width:60px;"></th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($list as $r): ?>
                <tr>
                  <td><code><?= e($r['pin_code']) ?></code></td>
                  <td>
                    <?= e($r['package_code']) ?>
                    <div class="small text-secondary">Rp <?= number_format((float)$r['price'],0,',','.') ?></div>
                  </td>
                  <td>
                    <span class="badge <?= $r['status']==='unused'?'bg-success':'bg-secondary' ?>">
                      <?= e(strtoupper($r['status'])) ?>
                    </span>
                  </td>
                  <td class="small"><?= !empty($r['assigned_note']) ? e($r['assigned_note']) : '<span class="text-secondary">-</span>' ?></td>
                  <td class="small"><?= !empty($r['assigned_at']) ? e($r['assigned_at']) : '<span class="text-secondary">-</span>' ?></td>
                  <td class="text-end">
                    <button class="btn btn-outline-primary btn-sm" type="button" data-copy="<?= e($r['pin_code']) ?>">
                      <i class="bi bi-clipboard"></i>
                    </button>
                  </td>
                </tr>
              <?php endforeach; ?>

              <?php if (empty($list)): ?>
                <tr><td colspan="6" class="text-center text-secondary py-3">Belum ada PIN yang dikirim admin.</td></tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>

        <?php if ($totalPages > 1): ?>
          <nav class="mt-2">
            <ul class="pagination pagination-sm mb-0">
              <?php for ($i=1; $i<=$totalPages; $i++): ?>
                <li class="page-item <?= $i===$pageNum?'active':'' ?>">
                  <a class="page-link" href="member.php?page=pins&status=<?= urlencode($status) ?>&p=<?= $i ?>">
                    <?= $i ?>
                  </a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>

      </div>
    </div>
  </div>
</div>
