<?php
$pdo = Db::pdo();
$memberId = (int)$member['id'];

$msg = null;
$err = null;

function cleanPhone($s) {
  $s = trim($s);
  $s = preg_replace('/[^0-9+]/', '', $s);
  return $s;
}
function cleanAccount($s) {
  $s = trim($s);
  $s = preg_replace('/[^0-9]/', '', $s);
  return $s;
}

// ambil data terbaru
$st = $pdo->prepare("
  SELECT username, full_name, phone, email, address, bank_name, bank_account
  FROM members
  WHERE id=? LIMIT 1
");
$st->execute([$memberId]);
$row = $st->fetch();
if (!$row) {
  echo '<div class="alert alert-danger">Member tidak ditemukan.</div>';
  return;
}

$val = [
  'full_name' => (string)($row['full_name'] ?? ''),
  'phone' => (string)($row['phone'] ?? ''),
  'email' => (string)($row['email'] ?? ''),
  'address' => (string)($row['address'] ?? ''),
  'bank_name' => (string)($row['bank_name'] ?? ''),
  'bank_account' => (string)($row['bank_account'] ?? ''),
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $val['full_name'] = trim($_POST['full_name'] ?? '');
  $val['phone'] = cleanPhone($_POST['phone'] ?? '');
  $val['email'] = trim($_POST['email'] ?? '');
  $val['address'] = trim($_POST['address'] ?? '');
  $val['bank_name'] = trim($_POST['bank_name'] ?? '');
  $val['bank_account'] = cleanAccount($_POST['bank_account'] ?? '');

  // Validasi simple
  if ($val['full_name'] === '') {
    $err = "Nama lengkap wajib diisi (sesuai data bank).";
  } elseif ($val['phone'] === '') {
    $err = "No. HP wajib diisi.";
  } elseif ($val['email'] !== '' && !filter_var($val['email'], FILTER_VALIDATE_EMAIL)) {
    $err = "Format email tidak valid.";
  } elseif ($val['bank_account'] !== '' && strlen($val['bank_account']) < 6) {
    $err = "No. rekening terlalu pendek.";
  }

  // Email unik (opsional, tapi bagus)
  if (!$err && $val['email'] !== '') {
    $st = $pdo->prepare("SELECT id FROM members WHERE email=? AND id<>? LIMIT 1");
    $st->execute([$val['email'], $memberId]);
    if ($st->fetch()) {
      $err = "Email sudah dipakai member lain.";
    }
  }

  if (!$err) {
    $pdo->prepare("
      UPDATE members
      SET full_name=?, phone=?, email=?, address=?, bank_name=?, bank_account=?, updated_at=NOW()
      WHERE id=?
    ")->execute([
      $val['full_name'],
      $val['phone'],
      $val['email'] !== '' ? $val['email'] : null,
      $val['address'] !== '' ? $val['address'] : null,
      $val['bank_name'] !== '' ? $val['bank_name'] : null,
      $val['bank_account'] !== '' ? $val['bank_account'] : null,
      $memberId
    ]);

    $msg = "Profile berhasil disimpan.";
  }
}
?>

<div class="row g-3">
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body d-flex flex-wrap justify-content-between align-items-center gap-2">
        <div>
          <h5 class="mb-1">Profile</h5>
          <div class="text-secondary small">
            Lengkapi data sesuai kebutuhan penarikan/withdraw (bank).
          </div>
        </div>
        <div class="small text-secondary">
          Username: <b><?= e($row['username']) ?></b>
        </div>
      </div>
    </div>
  </div>

  <div class="col-12">
    <?php if ($msg): ?><div class="alert alert-success"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-danger"><?= e($err) ?></div><?php endif; ?>
  </div>

  <div class="col-12 col-lg-8">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <form method="post" autocomplete="off" class="row g-2">

          <div class="col-12">
            <label class="form-label mb-1">Nama lengkap (sesuai data Bank) <span class="text-danger">*</span></label>
            <input class="form-control" name="full_name" value="<?= e($val['full_name']) ?>" required>
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label mb-1">No. HP <span class="text-danger">*</span></label>
            <input class="form-control" name="phone" value="<?= e($val['phone']) ?>" placeholder="08xxxx" required>
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label mb-1">Email</label>
            <input type="email" class="form-control" name="email" value="<?= e($val['email']) ?>" placeholder="nama@email.com">
          </div>

          <div class="col-12">
            <label class="form-label mb-1">Alamat</label>
            <textarea class="form-control" name="address" rows="3" placeholder="Alamat lengkap"><?= e($val['address']) ?></textarea>
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label mb-1">Bank</label>
            <input class="form-control" name="bank_name" value="<?= e($val['bank_name']) ?>" placeholder="BCA / BRI / Mandiri / dll">
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label mb-1">No. Rekening</label>
            <input class="form-control" name="bank_account" value="<?= e($val['bank_account']) ?>" placeholder="Hanya angka">
            <div class="form-text">Disarankan hanya angka (tanpa spasi/titik).</div>
          </div>

          <div class="col-12 mt-2">
            <button class="btn btn-primary w-100">
              <i class="bi bi-save me-1"></i> Simpan Profile
            </button>
          </div>

        </form>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-2">Catatan</h6>
        <ul class="mb-0 text-secondary small">
          <li>Nama harus sama dengan rekening bank untuk proses withdraw.</li>
          <li>Email optional, tapi bagus untuk notifikasi.</li>
          <li>Bank & No. rekening akan dipakai saat fitur withdraw dibuat.</li>
        </ul>
      </div>
    </div>
  </div>
</div>
