<?php
$pdo = Db::pdo();


$memberId = (int)($member['id'] ?? 0);
$sponsorId = $memberId; // sponsor selalu member yang login
$sponsorUsername = (string)($member['username'] ?? '');

$msg = null;
$err = null;
$warn = null;
$newMemberId = null;

// ambil PIN aktivasi milik member (assigned) yang masih unused
$st = $pdo->prepare("
  SELECT p.id, p.pin_code, p.package_id, pk.code AS package_code, pk.price
  FROM pins_activation p
  JOIN packages pk ON pk.id = p.package_id
  WHERE p.assigned_to_member_id = ?
    AND p.status = 'unused'
  ORDER BY p.id DESC
  LIMIT 200
");
$st->execute([$sponsorId]);
$myPins = $st->fetchAll(PDO::FETCH_ASSOC);

function rupiah($n) { return 'Rp ' . number_format((float)$n, 0, ',', '.'); }
function cleanPhone($s) { return preg_replace('/[^0-9+]/','', trim((string)$s)); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pinCode  = strtoupper(trim($_POST['pin_code'] ?? ''));
  $legReq   = strtoupper(trim($_POST['leg'] ?? '')); // wajib L/R

  $uplineInput = trim($_POST['upline'] ?? ''); // opsional username / id

  $username = trim($_POST['username'] ?? '');
  $password = (string)($_POST['password'] ?? '');
  $password2= (string)($_POST['password2'] ?? '');

  $fullName = trim($_POST['full_name'] ?? '');
  $phone    = cleanPhone($_POST['phone'] ?? '');

  // validasi minimal
  if ($pinCode === '') {
    $err = "PIN wajib dipilih.";
  } elseif (!in_array($legReq, ['L','R'], true)) {
    $err = "Posisi wajib dipilih (L/R).";
  } elseif ($username === '' || $password === '' || $password2 === '') {
    $err = "Username dan password wajib diisi.";
  } elseif ($password !== $password2) {
    $err = "Password dan konfirmasi tidak sama.";
  } elseif (strlen($password) < 6) {
    $err = "Password minimal 6 karakter.";
  }

  if (!$err) {
    try {
      $pdo->beginTransaction();

      // ======================
      // 1) LOCK PIN (harus milik sponsor & unused)
      // ======================
      $st = $pdo->prepare("
        SELECT id, package_id, status, assigned_to_member_id
        FROM pins_activation
        WHERE pin_code = ?
        LIMIT 1
        FOR UPDATE
      ");
      $st->execute([$pinCode]);
      $pin = $st->fetch(PDO::FETCH_ASSOC);
      if (!$pin) throw new Exception("PIN tidak ditemukan.");
      if ((int)$pin['assigned_to_member_id'] !== $sponsorId) throw new Exception("PIN ini bukan milik kamu.");
      if ($pin['status'] !== 'unused') throw new Exception("PIN sudah digunakan.");

      $packageId = (int)$pin['package_id'];
      if ($packageId <= 0) throw new Exception("PIN paket tidak valid.");

      // ======================
      // 2) CEK USERNAME (hindari double)
      // ======================
      $st = $pdo->prepare("SELECT id FROM members WHERE username=? LIMIT 1 FOR UPDATE");
      $st->execute([$username]);
      if ($st->fetch()) throw new Exception("Username sudah digunakan.");

      // ======================
      // 3) INSERT MEMBER BARU (langsung ACTIVE)
      // ======================
      $hash = password_hash($password, PASSWORD_BCRYPT);

      $pdo->prepare("
        INSERT INTO members
          (username, password_hash, full_name, phone, role, sponsor_id, package_id, status, activated_at, created_at, updated_at)
        VALUES
          (?, ?, ?, ?, 'member', ?, ?, 'active', NOW(), NOW(), NOW())
      ")->execute([
        $username,
        $hash,
        ($fullName !== '' ? $fullName : null),
        ($phone !== '' ? $phone : null),
        $sponsorId,
        $packageId
      ]);

      $newMemberId = (int)$pdo->lastInsertId();

      // ======================
      // 4) CONSUME PIN
      // ======================
      $pdo->prepare("
        UPDATE pins_activation
        SET status='used', used_by_member_id=?, used_at=NOW()
        WHERE id=?
      ")->execute([$newMemberId, (int)$pin['id']]);

      // ======================
      // 5) FINAL: Tentukan upline placement (opsional, ANTI ERROR)
      // - default sponsor langsung
      // - jika upline salah / beda jaringan => fallback sponsor (WARNING, bukan ERROR)
      // ======================
      $placementUplineId = (int)$sponsorId; // default
      $warn = null;

      if ($uplineInput !== '') {
        $uplId = 0;

        // ID jika angka
        if (ctype_digit($uplineInput)) {
          $st = $pdo->prepare("SELECT id FROM members WHERE id=? LIMIT 1");
          $st->execute([(int)$uplineInput]);
          $uplId = (int)($st->fetchColumn() ?: 0);
        } else {
          // Username (case-insensitive)
          $st = $pdo->prepare("SELECT id FROM members WHERE LOWER(username)=LOWER(?) LIMIT 1");
          $st->execute([$uplineInput]);
          $uplId = (int)($st->fetchColumn() ?: 0);
        }

        if ($uplId <= 0) {
          $warn = "Upline tidak ditemukan, sistem pakai sponsor langsung.";
        } else {
          // validasi ringan: upline harus berada di bawah jaringan sponsor (naik sponsor_id sampai ketemu sponsorId)
          $cur = $uplId;
          $ok = false;
          $guard = 0;

          while ($cur > 0) {
            if ($cur === (int)$sponsorId) { $ok = true; break; }
            $st = $pdo->prepare("SELECT sponsor_id FROM members WHERE id=? LIMIT 1");
            $st->execute([$cur]);
            $cur = (int)($st->fetchColumn() ?: 0);
            if (++$guard > 1000) break;
          }

          if ($ok) {
            $placementUplineId = $uplId;
          } else {
            $warn = "Upline beda jaringan sponsor, sistem pakai sponsor langsung.";
          }
        }
      }

      // ======================
      // 6) AUTO PLACEMENT sesuai leg (spillover 1 jalur)
      // ======================
      $parentId = (int)$placementUplineId;
      if ($parentId <= 0) throw new Exception("Parent placement tidak valid.");

      $finalLeg = $legReq;

      $findSlot = function($parentId, $leg) use ($pdo) {
        $st = $pdo->prepare("SELECT id FROM binary_placements WHERE parent_id=? AND leg=? LIMIT 1");
        $st->execute([(int)$parentId, $leg]);
        return $st->fetch() ? false : true;
      };

      $getChild = function($parentId, $leg) use ($pdo) {
        $st = $pdo->prepare("SELECT member_id FROM binary_placements WHERE parent_id=? AND leg=? LIMIT 1");
        $st->execute([(int)$parentId, $leg]);
        $r = $st->fetch(PDO::FETCH_ASSOC);
        return $r ? (int)$r['member_id'] : 0;
      };

      // spillover: turun terus di jalur yang sama sampai slot kosong
      $guard = 0;
      while (!$findSlot($parentId, $finalLeg)) {
        $child = $getChild($parentId, $finalLeg);
        if ($child <= 0) break;
        $parentId = $child;

        $guard++;
        if ($guard > 10000) throw new Exception("Spillover terlalu dalam (safety stop).");
      }

      // lock slot sebelum insert (hindari race)
      $st = $pdo->prepare("SELECT id FROM binary_placements WHERE parent_id=? AND leg=? LIMIT 1 FOR UPDATE");
      $st->execute([$parentId, $finalLeg]);
      if ($st->fetch()) throw new Exception("Slot upline sudah terisi (coba ulang).");

      // pastikan member baru belum ada placement
      $st = $pdo->prepare("SELECT id FROM binary_placements WHERE member_id=? LIMIT 1 FOR UPDATE");
      $st->execute([$newMemberId]);
      if ($st->fetch()) throw new Exception("Member sudah punya placement.");

      $pdo->prepare("INSERT INTO binary_placements (member_id, parent_id, leg) VALUES (?,?,?)")
          ->execute([$newMemberId, $parentId, $finalLeg]);
          require_once __DIR__ . '/../../services/PlanARewardService.php';
          PlanARewardService::onMemberActivated($pdo, $newMemberId);
          require_once __DIR__ . '/../../services/PlanAMatchingService.php';
          PlanAMatchingService::onNodeMaybePaired($pdo, (int)$parentId);



      // ======================
      // 7) SPONSOR BONUS (AUTO CREDIT)
      // bonus sponsor ditentukan dari paket member baru
      // WARRIOR=70000, SMART=500000, RICH=1000000
      // ======================
      $bonusSponsor = 0;
      if ($packageId === 1) $bonusSponsor = 70000;
      elseif ($packageId === 2) $bonusSponsor = 500000;
      elseif ($packageId === 3) $bonusSponsor = 1000000;

      if ($bonusSponsor > 0) {
        // ensure wallet sponsor
        $st = $pdo->prepare("SELECT member_id FROM wallets WHERE member_id=? LIMIT 1 FOR UPDATE");
        $st->execute([$sponsorId]);
        if (!$st->fetch()) {
          $pdo->prepare("INSERT INTO wallets (member_id, balance) VALUES (?, 0.00)")
              ->execute([$sponsorId]);
        }

        // credit
        $pdo->prepare("UPDATE wallets SET balance = balance + ? WHERE member_id=?")
            ->execute([$bonusSponsor, $sponsorId]);

        // log transaksi
        $desc = "Sponsor bonus dari registrasi: {$username} (leg {$finalLeg})";
        $pdo->prepare("
          INSERT INTO wallet_transactions (member_id, tx_type, amount, description, ref_table, ref_id, created_at)
          VALUES (?, 'sponsor', ?, ?, 'members', ?, NOW())
        ")->execute([
          $sponsorId,
          $bonusSponsor,
          $desc,
          $newMemberId
        ]);
      }

      require_once __DIR__ . '/../../services/PlanADailyBonusService.php';
PlanADailyBonusService::checkAndActivate($pdo, (int)$sponsorId);


      $pdo->commit();

      $msg = "Register berhasil. Member ACTIVE & ditempatkan jalur {$finalLeg}.";
    } catch (Throwable $e) {
      if ($pdo->inTransaction()) $pdo->rollBack();
      $err = $e->getMessage();
      $newMemberId = null;
    }
  }
}
?>

<div class="row g-3">
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body d-flex flex-wrap justify-content-between align-items-center gap-2">
        <div>
          <h5 class="mb-1">Register Downline</h5>
          <div class="text-secondary small">
            Sponsor: <b><?= e($sponsorUsername) ?></b> • Downline langsung <b>ACTIVE</b>
          </div>
        </div>
        <a class="btn btn-outline-secondary btn-sm" href="/jwdnetwork/member.php?page=network">
          <i class="bi bi-diagram-3 me-1"></i> Network
        </a>
      </div>
    </div>
  </div>

  <div class="col-12">
    <?php if ($err): ?>
      <div class="alert alert-danger"><?= e($err) ?></div>
    <?php endif; ?>
    <?php if ($msg): ?>
      <div class="alert alert-success">
        <div class="fw-semibold"><?= e($msg) ?></div>
        <?php if ($newMemberId): ?>
          <div class="small">Member ID: <b><?= (int)$newMemberId ?></b></div>
        <?php endif; ?>
      </div>
    <?php endif; ?>
    <?php if (!empty($warn)): ?>
      <div class="alert alert-warning"><?= e($warn) ?></div>
    <?php endif; ?>
  </div>

  <div class="col-12 col-lg-7">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-3">Form Pendaftaran</h6>

        <?php if (empty($myPins)): ?>
          <div class="alert alert-warning mb-0">
            Kamu belum punya PIN unused. Minta admin assign PIN dulu.
          </div>
        <?php else: ?>
          <form method="post" autocomplete="off" class="row g-2">

            <div class="col-12">
              <label class="form-label mb-1">Pilih PIN (wajib)</label>
              <select class="form-select" name="pin_code" required>
                <option value="">-- pilih PIN --</option>
                <?php foreach ($myPins as $p): ?>
                  <option value="<?= e($p['pin_code']) ?>" <?= (($_POST['pin_code'] ?? '') === $p['pin_code']) ? 'selected' : '' ?>>
                    <?= e($p['pin_code']) ?> • <?= e($p['package_code']) ?> (<?= rupiah($p['price']) ?>)
                  </option>
                <?php endforeach; ?>
              </select>
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label mb-1">Penempatan Upline (opsional)</label>
              <input
                type="text"
                class="form-control"
                name="upline"
                value="<?= e($_POST['upline'] ?? '') ?>"
                placeholder="username / ID upline (kosong = sponsor langsung)">
              <div class="form-text">Jika upline salah / beda jaringan, otomatis pakai sponsor langsung.</div>
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label mb-1">Posisi (wajib)</label>
              <select class="form-select" name="leg" required>
                <option value="">-- pilih --</option>
                <option value="L" <?= (($_POST['leg'] ?? '')==='L')?'selected':'' ?>>Kiri (L)</option>
                <option value="R" <?= (($_POST['leg'] ?? '')==='R')?'selected':'' ?>>Kanan (R)</option>
              </select>
              <div class="form-text">Spillover mengikuti jalur yang sama sampai slot kosong.</div>
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label mb-1">No HP (opsional)</label>
              <input class="form-control" name="phone" value="<?= e($_POST['phone'] ?? '') ?>" placeholder="08xxxx">
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label mb-1">Nama Lengkap (opsional)</label>
              <input class="form-control" name="full_name" value="<?= e($_POST['full_name'] ?? '') ?>">
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label mb-1">Username</label>
              <input class="form-control" name="username" required value="<?= e($_POST['username'] ?? '') ?>" placeholder="contoh: userbaru">
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label mb-1">Password</label>
              <input type="password" class="form-control" name="password" required>
              <div class="form-text">Minimal 6 karakter.</div>
            </div>

            <div class="col-12">
              <label class="form-label mb-1">Ulangi Password</label>
              <input type="password" class="form-control" name="password2" required>
            </div>

            <div class="col-12 mt-2">
              <button class="btn btn-primary w-100">
                <i class="bi bi-person-plus me-1"></i> Register Downline (Auto Active)
              </button>
            </div>

          </form>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-5">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-2">Aturan</h6>
        <ul class="mb-0 text-secondary small">
          <li>Member baru langsung <b>ACTIVE</b>.</li>
          <li>PIN otomatis berubah menjadi <b>USED</b>.</li>
          <li>Upline opsional: jika salah/beda jaringan → fallback sponsor.</li>
          <li>Placement mengikuti leg pilihan (L/R) sampai slot kosong.</li>
          <li>Sponsor bonus otomatis masuk wallet sponsor.</li>
        </ul>
      </div>
    </div>
  </div>
</div>
