<?php
$pdo = Db::pdo();
$memberId = (int)$member['id'];

$perPage = 25;
$pageNum = isset($_GET['p']) ? (int)$_GET['p'] : 1;
if ($pageNum < 1) $pageNum = 1;

// ✅ FILTER TX TYPE
$tx = isset($_GET['tx']) ? strtolower(trim($_GET['tx'])) : '';
$allowedTx = ['','sponsor','matching','daily','reward','royalty','withdraw','adjust'];

// kalau user isi macam-macam, amankan
if (!in_array($tx, $allowedTx, true)) $tx = '';

$where = "member_id=?";
$params = [$memberId];

if ($tx !== '') {
  $where .= " AND LOWER(tx_type)=?";
  $params[] = $tx;
}

// total rows (pakai filter)
$st = $pdo->prepare("SELECT COUNT(*) AS c FROM wallet_transactions WHERE {$where}");
$st->execute($params);
$totalRows = (int)$st->fetch()['c'];

$pg = paginate_meta($totalRows, $pageNum, $perPage);

// data rows (pakai filter)
$sql = "
  SELECT id, tx_type, amount, description, ref_table, ref_id, created_at
  FROM wallet_transactions
  WHERE {$where}
  ORDER BY id DESC
  LIMIT {$pg['perPage']} OFFSET {$pg['offset']}
";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

// saldo
$st = $pdo->prepare("SELECT balance FROM wallets WHERE member_id=? LIMIT 1");
$st->execute([$memberId]);
$w = $st->fetch();
$balance = $w ? (float)$w['balance'] : 0.0;

function rupiah($n) {
  return 'Rp ' . number_format((float)$n, 0, ',', '.');
}

function badge_tx($type) {
  $type = strtolower((string)$type);
  $map = [
    'sponsor' => 'primary',
    'matching' => 'success',
    'daily' => 'warning',
    'reward' => 'info',
    'royalty' => 'secondary',
    'withdraw' => 'danger',
    'adjust' => 'dark'
  ];
  $cls = $map[$type] ?? 'light';
  return '<span class="badge bg-'.$cls.'">'.e(strtoupper($type)).'</span>';
}

// ✅ URL pagination tetap bawa tx
function reports_url($p, $tx) {
  $base = '/jwdnetwork/member.php?page=reports&p='.(int)$p;
  if ($tx !== '') $base .= '&tx='.urlencode($tx);
  return $base;
}

$start = max(1, $pg['page'] - 2);
$end   = min($pg['totalPages'], $pg['page'] + 2);

// untuk dropdown label
$txLabels = [
  '' => 'Semua',
  'sponsor' => 'Sponsor',
  'matching' => 'Matching',
  'daily' => 'Daily',
  'reward' => 'Reward',
  'royalty' => 'Royalty',
  'withdraw' => 'Withdraw',
  'adjust' => 'Adjust',
];
?>

<div class="row g-3">
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body d-flex flex-wrap gap-3 justify-content-between align-items-center">
        <div>
          <h5 class="mb-1">Reports / Mutasi Wallet</h5>
          <div class="text-secondary small">
            Filter: <b><?= e($txLabels[$tx] ?? 'Semua') ?></b>
            • Total transaksi: <b><?= number_format($pg['totalRows']) ?></b>
            • Halaman <b><?= $pg['page'] ?></b> / <b><?= $pg['totalPages'] ?></b>
          </div>
        </div>

        <div class="text-end">
          <div class="text-secondary small">Saldo</div>
          <div class="fs-5 fw-bold"><?= rupiah($balance) ?></div>
        </div>
      </div>
    </div>
  </div>

  <!-- ✅ FILTER BAR -->
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <form class="row g-2 align-items-end" method="get" action="/jwdnetwork/member.php">
          <input type="hidden" name="page" value="reports">
          <input type="hidden" name="p" value="1">

          <div class="col-12 col-md-4">
            <label class="form-label mb-1">Tipe Transaksi</label>
            <select class="form-select" name="tx">
              <?php foreach ($txLabels as $k => $label): ?>
                <option value="<?= e($k) ?>" <?= $k === $tx ? 'selected' : '' ?>>
                  <?= e($label) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-12 col-md-8 d-flex gap-2">
            <button class="btn btn-primary" type="submit">
              <i class="bi bi-funnel me-1"></i> Apply
            </button>
            <a class="btn btn-outline-secondary" href="/jwdnetwork/member.php?page=reports">
              Reset
            </a>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- TABLE -->
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th style="width:170px;">Tanggal</th>
                <th style="width:120px;">Tipe</th>
                <th style="width:160px;" class="text-end">Jumlah</th>
                <th>Deskripsi</th>
                <th style="width:160px;">Ref</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($rows)): ?>
                <tr>
                  <td colspan="5" class="text-center py-4 text-secondary">Tidak ada data untuk filter ini.</td>
                </tr>
              <?php else: ?>
                <?php foreach ($rows as $r): ?>
                  <tr>
                    <td>
                      <div class="fw-semibold"><?= e(date('Y-m-d', strtotime($r['created_at']))) ?></div>
                      <div class="small text-secondary"><?= e(date('H:i:s', strtotime($r['created_at']))) ?></div>
                    </td>
                    <?php
$type = strtolower($r['tx_type']);
$badge = 'secondary';

if ($type === 'daily_bonus')      $badge = 'success';
elseif ($type === 'matching')     $badge = 'warning';
elseif ($type === 'sponsor')      $badge = 'primary';
elseif ($type === 'pairing')      $badge = 'info';
elseif ($type === 'withdraw')     $badge = 'danger';
?>

<td>
  <span class="badge bg-<?= $badge ?>">
    <?= e(strtoupper($r['tx_type'])) ?>
  </span>
</td>
                    <td class="text-end fw-bold"><?= rupiah($r['amount']) ?></td>
                    <td>
                      <div class="fw-semibold">#<?= (int)$r['id'] ?></div>
                      <div class="text-secondary small"><?= e($r['description'] ?: '-') ?></div>
                    </td>
                    <td class="small">
                      <?php if (!empty($r['ref_table'])): ?>
                        <div><?= e($r['ref_table']) ?></div>
                        <div class="text-secondary">ID: <?= e($r['ref_id']) ?></div>
                      <?php else: ?>
                        <span class="text-secondary">-</span>
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>

      <!-- PAGINATION -->
      <?php if ($pg['totalPages'] > 1): ?>
      <div class="card-footer bg-white">
        <nav aria-label="Pagination">
          <ul class="pagination mb-0 flex-wrap">
            <li class="page-item <?= $pg['page'] <= 1 ? 'disabled' : '' ?>">
              <a class="page-link" href="<?= reports_url(1, $tx) ?>">&laquo;</a>
            </li>
            <li class="page-item <?= $pg['page'] <= 1 ? 'disabled' : '' ?>">
              <a class="page-link" href="<?= reports_url($pg['page'] - 1, $tx) ?>">&lsaquo;</a>
            </li>

            <?php if ($start > 1): ?>
              <li class="page-item disabled"><span class="page-link">...</span></li>
            <?php endif; ?>

            <?php for ($i=$start; $i<=$end; $i++): ?>
              <li class="page-item <?= $i === $pg['page'] ? 'active' : '' ?>">
                <a class="page-link" href="<?= reports_url($i, $tx) ?>"><?= $i ?></a>
              </li>
            <?php endfor; ?>

            <?php if ($end < $pg['totalPages']): ?>
              <li class="page-item disabled"><span class="page-link">...</span></li>
            <?php endif; ?>

            <li class="page-item <?= $pg['page'] >= $pg['totalPages'] ? 'disabled' : '' ?>">
              <a class="page-link" href="<?= reports_url($pg['page'] + 1, $tx) ?>">&rsaquo;</a>
            </li>
            <li class="page-item <?= $pg['page'] >= $pg['totalPages'] ? 'disabled' : '' ?>">
              <a class="page-link" href="<?= reports_url($pg['totalPages'], $tx) ?>">&raquo;</a>
            </li>
          </ul>
        </nav>
      </div>
      <?php endif; ?>
    </div>
  </div>
</div>
