<?php
$pdo = Db::pdo();
$memberId = (int)$member['id'];

function rupiah($n){ return 'Rp ' . number_format((float)$n, 0, ',', '.'); }

$st = $pdo->prepare("
  SELECT
    COALESCE(SUM(CASE WHEN leg='L' THEN points ELSE 0 END),0) AS left_pts,
    COALESCE(SUM(CASE WHEN leg='R' THEN points ELSE 0 END),0) AS right_pts
  FROM plan_a_reward_points
  WHERE member_id=?
");
$st->execute([$memberId]);
$t = $st->fetch(PDO::FETCH_ASSOC);
$leftPts  = (int)($t['left_pts'] ?? 0);
$rightPts = (int)($t['right_pts'] ?? 0);

$targets = [
  ['code'=>'MOTOR_20', 'name'=>'Motor', 'value'=>10000000, 'need'=>20],
  ['code'=>'BRIO_200', 'name'=>'Brio', 'value'=>120000000, 'need'=>200],
  ['code'=>'PAJERO_1200', 'name'=>'Pajero', 'value'=>500000000, 'need'=>1200],
];

$st = $pdo->prepare("SELECT milestone_code, achieved_at FROM plan_a_reward_milestones WHERE member_id=?");
$st->execute([$memberId]);
$got = [];
foreach ($st->fetchAll(PDO::FETCH_ASSOC) as $r) $got[$r['milestone_code']] = $r['achieved_at'];

$st = $pdo->prepare("
  SELECT leg, points, source_member_id, source_package_id, created_at
  FROM plan_a_reward_points
  WHERE member_id=?
  ORDER BY id DESC
  LIMIT 25
");
$st->execute([$memberId]);
$logs = $st->fetchAll(PDO::FETCH_ASSOC);

$pkgName = function($pid){
  if ((int)$pid===2) return 'SMART';
  if ((int)$pid===3) return 'RICH';
  return '-';
};
?>

<div class="row g-3">
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body d-flex flex-wrap justify-content-between align-items-center gap-2">
        <div>
          <h5 class="mb-1">Reward Plan A</h5>
          <div class="text-secondary small">Poin dihitung dari downline SMART/RICH di jaringan (tidak harus sponsor langsung).</div>
        </div>
        <div class="text-end">
          <div class="small text-secondary">Total Poin</div>
          <div class="fw-bold">
            Kiri: <span class="fs-5"><?= (int)$leftPts ?></span>
            &nbsp; | &nbsp;
            Kanan: <span class="fs-5"><?= (int)$rightPts ?></span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php foreach ($targets as $x): 
    $need = (int)$x['need'];
    $ok = ($leftPts >= $need && $rightPts >= $need);
    $ach = $got[$x['code']] ?? null;

    $pL = min(100, (int)floor(($leftPts / max(1,$need))*100));
    $pR = min(100, (int)floor(($rightPts / max(1,$need))*100));
  ?>
    <div class="col-12 col-lg-4">
      <div class="card border-0 shadow-sm h-100">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <div class="text-secondary small">Target <?= (int)$need ?> - <?= (int)$need ?></div>
              <div class="fs-5 fw-bold"><?= e($x['name']) ?></div>
              <div class="small text-secondary"><?= rupiah($x['value']) ?></div>
            </div>
            <?php if ($ach): ?>
              <span class="badge bg-success">ACHIEVED</span>
            <?php elseif ($ok): ?>
              <span class="badge bg-warning text-dark">READY</span>
            <?php else: ?>
              <span class="badge bg-secondary">PROGRESS</span>
            <?php endif; ?>
          </div>

          <div class="mt-3">
            <div class="small text-secondary mb-1">Kiri (<?= (int)$leftPts ?>/<?= $need ?>)</div>
            <div class="progress" style="height:10px;">
              <div class="progress-bar" style="width: <?= $pL ?>%"></div>
            </div>
          </div>

          <div class="mt-3">
            <div class="small text-secondary mb-1">Kanan (<?= (int)$rightPts ?>/<?= $need ?>)</div>
            <div class="progress" style="height:10px;">
              <div class="progress-bar" style="width: <?= $pR ?>%"></div>
            </div>
          </div>

          <?php if ($ach): ?>
            <div class="small text-secondary mt-3">Achieved at: <b><?= e($ach) ?></b></div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endforeach; ?>

  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="mb-0">Log Poin (25 terakhir)</h6>
          <span class="small text-secondary">SMART=1 poin • RICH=2 poin</span>
        </div>

        <div class="table-responsive">
          <table class="table table-sm align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th style="width:90px;">Leg</th>
                <th style="width:120px;">Poin</th>
                <th style="width:160px;">Sumber</th>
                <th style="width:170px;">Tanggal</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($logs)): ?>
                <tr><td colspan="4" class="text-center text-secondary py-3">Belum ada poin.</td></tr>
              <?php else: foreach ($logs as $r): ?>
                <tr>
                  <td><span class="badge bg-dark"><?= e($r['leg']) ?></span></td>
                  <td class="fw-bold"><?= (int)$r['points'] ?></td>
                  <td class="small text-secondary">#<?= (int)$r['source_member_id'] ?> (<?= e($pkgName($r['source_package_id'])) ?>)</td>
                  <td class="small text-secondary"><?= e($r['created_at']) ?></td>
                </tr>
              <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
