<?php
$pdo = Db::pdo();
$memberId = (int)$member['id'];

$perPage = 25;
$pageNum = isset($_GET['p']) ? (int)$_GET['p'] : 1;
if ($pageNum < 1) $pageNum = 1;

// Filter tx_type (optional)
$tx = isset($_GET['tx']) ? strtolower(trim($_GET['tx'])) : '';
$allowedTx = ['','sponsor','matching','daily','royalty','withdraw','adjust'];
if (!in_array($tx, $allowedTx, true)) $tx = '';

$where = "member_id=?";
$params = [$memberId];
if ($tx !== '') {
  $where .= " AND LOWER(tx_type)=?";
  $params[] = $tx;
}

// saldo
$st = $pdo->prepare("SELECT balance FROM wallets WHERE member_id=? LIMIT 1");
$st->execute([$memberId]);
$w = $st->fetch();
$balance = $w ? (float)$w['balance'] : 0.0;

// ringkasan bulan ini (masuk/keluar)
$monthStart = date('Y-m-01 00:00:00');
$nextMonth  = date('Y-m-01 00:00:00', strtotime('+1 month'));

$st = $pdo->prepare("
  SELECT
    COALESCE(SUM(CASE WHEN amount > 0 THEN amount ELSE 0 END),0) AS total_in,
    COALESCE(SUM(CASE WHEN amount < 0 THEN -amount ELSE 0 END),0) AS total_out
  FROM wallet_transactions
  WHERE member_id=?
    AND created_at >= ?
    AND created_at < ?
");
$st->execute([$memberId, $monthStart, $nextMonth]);
$sum = $st->fetch();
$totalIn  = (float)$sum['total_in'];
$totalOut = (float)$sum['total_out'];

// total rows (pakai filter)
$st = $pdo->prepare("SELECT COUNT(*) AS c FROM wallet_transactions WHERE {$where}");
$st->execute($params);
$totalRows = (int)$st->fetch()['c'];

$pg = paginate_meta($totalRows, $pageNum, $perPage);

// rows
$sql = "
  SELECT id, tx_type, amount, description, ref_table, ref_id, created_at
  FROM wallet_transactions
  WHERE {$where}
  ORDER BY id DESC
  LIMIT {$pg['perPage']} OFFSET {$pg['offset']}
";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

function rupiah($n) { return 'Rp ' . number_format((float)$n, 0, ',', '.'); }

function badge_tx($type) {
  $type = strtolower((string)$type);
  $map = [
    'sponsor' => 'primary',
    'matching' => 'success',
    'daily' => 'warning',
    
    'royalty' => 'secondary',
    'withdraw' => 'danger',
    'adjust' => 'dark'
  ];
  $cls = $map[$type] ?? 'light';
  return '<span class="badge bg-'.$cls.'">'.e(strtoupper($type)).'</span>';
}

$txLabels = [
  '' => 'Semua',
  'sponsor' => 'Sponsor',
  'matching' => 'Matching',
  'daily' => 'Daily',
 
  'royalty' => 'Royalty',
  'withdraw' => 'Withdraw',
  'adjust' => 'Adjust',
];

function wallet_url($p, $tx) {
  $q = '/jwdnetwork/member.php?page=wallet&p='.(int)$p;
  if ($tx !== '') $q .= '&tx='.urlencode($tx);
  return $q;
}

$start = max(1, $pg['page'] - 2);
$end   = min($pg['totalPages'], $pg['page'] + 2);
?>

<div class="row g-3">
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body d-flex flex-wrap justify-content-between align-items-center gap-3">
        <div>
          <h5 class="mb-1">Wallet</h5>
          <div class="text-secondary small">
            Mutasi wallet & saldo kamu. Filter: <b><?= e($txLabels[$tx] ?? 'Semua') ?></b>
          </div>
        </div>
        <div class="text-end">
          <div class="text-secondary small">Saldo</div>
          <div class="fs-4 fw-bold"><?= rupiah($balance) ?></div>
        </div>
      </div>
    </div>
  </div>

  <!-- Summary -->
  <div class="col-12 col-md-6 col-lg-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="text-secondary small">Masuk (bulan ini)</div>
        <div class="fs-5 fw-bold"><?= rupiah($totalIn) ?></div>
      </div>
    </div>
  </div>
  <div class="col-12 col-md-6 col-lg-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="text-secondary small">Keluar (bulan ini)</div>
        <div class="fs-5 fw-bold"><?= rupiah($totalOut) ?></div>
      </div>
    </div>
  </div>
  <div class="col-12 col-lg-4">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="text-secondary small">Aksi</div>
        <div class="d-flex gap-2 mt-2 flex-wrap">
          <!-- nanti kita sambung ke modul withdraw -->
          <button class="btn btn-outline-primary btn-sm" type="button" disabled>
            <i class="bi bi-cash-coin me-1"></i> Withdraw (soon)
          </button>
          <a class="btn btn-outline-secondary btn-sm" href="/jwdnetwork/member.php?page=reports">
            <i class="bi bi-receipt me-1"></i> Lihat Reports
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- Filter -->
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <form class="row g-2 align-items-end" method="get" action="/jwdnetwork/member.php">
          <input type="hidden" name="page" value="wallet">
          <input type="hidden" name="p" value="1">

          <div class="col-12 col-md-4">
            <label class="form-label mb-1">Tipe Transaksi</label>
            <select class="form-select" name="tx">
              <?php foreach ($txLabels as $k => $label): ?>
                <option value="<?= e($k) ?>" <?= $k === $tx ? 'selected' : '' ?>><?= e($label) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-12 col-md-8 d-flex gap-2">
            <button class="btn btn-primary" type="submit">
              <i class="bi bi-funnel me-1"></i> Apply
            </button>
            <a class="btn btn-outline-secondary" href="/jwdnetwork/member.php?page=wallet">Reset</a>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Table -->
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th style="width:170px;">Tanggal</th>
                <th style="width:120px;">Tipe</th>
                <th style="width:160px;" class="text-end">Jumlah</th>
                <th>Deskripsi</th>
                <th style="width:160px;">Ref</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($rows)): ?>
                <tr>
                  <td colspan="5" class="text-center py-4 text-secondary">Belum ada transaksi.</td>
                </tr>
              <?php else: ?>
                <?php foreach ($rows as $r): ?>
                  <tr>
                    <td>
                      <div class="fw-semibold"><?= e(date('Y-m-d', strtotime($r['created_at']))) ?></div>
                      <div class="small text-secondary"><?= e(date('H:i:s', strtotime($r['created_at']))) ?></div>
                    </td>
                    <?php
$type = strtolower($r['tx_type']);
$badge = 'secondary';

if ($type === 'daily_bonus')      $badge = 'success';
elseif ($type === 'matching')     $badge = 'warning';
elseif ($type === 'sponsor')      $badge = 'primary';
elseif ($type === 'pairing')      $badge = 'info';
elseif ($type === 'withdraw')     $badge = 'danger';
?>

<td>
  <span class="badge bg-<?= $badge ?>">
    <?= e(strtoupper($r['tx_type'])) ?>
  </span>
</td>
                    <td class="text-end fw-bold">
                      <?php
                        $amt = (float)$r['amount'];
                        echo $amt >= 0 ? rupiah($amt) : '<span class="text-danger">'.rupiah($amt).'</span>';
                      ?>
                    </td>
                    <td>
                      <div class="fw-semibold">#<?= (int)$r['id'] ?></div>
                      <div class="text-secondary small"><?= e($r['description'] ?: '-') ?></div>
                    </td>
                    <td class="small">
                      <?php if (!empty($r['ref_table'])): ?>
                        <div><?= e($r['ref_table']) ?></div>
                        <div class="text-secondary">ID: <?= e($r['ref_id']) ?></div>
                      <?php else: ?>
                        <span class="text-secondary">-</span>
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>

      <?php if ($pg['totalPages'] > 1): ?>
      <div class="card-footer bg-white">
        <nav aria-label="Pagination">
          <ul class="pagination mb-0 flex-wrap">
            <li class="page-item <?= $pg['page'] <= 1 ? 'disabled' : '' ?>">
              <a class="page-link" href="<?= wallet_url(1, $tx) ?>">&laquo;</a>
            </li>
            <li class="page-item <?= $pg['page'] <= 1 ? 'disabled' : '' ?>">
              <a class="page-link" href="<?= wallet_url($pg['page'] - 1, $tx) ?>">&lsaquo;</a>
            </li>

            <?php if ($start > 1): ?>
              <li class="page-item disabled"><span class="page-link">...</span></li>
            <?php endif; ?>

            <?php for ($i=$start; $i<=$end; $i++): ?>
              <li class="page-item <?= $i === $pg['page'] ? 'active' : '' ?>">
                <a class="page-link" href="<?= wallet_url($i, $tx) ?>"><?= $i ?></a>
              </li>
            <?php endfor; ?>

            <?php if ($end < $pg['totalPages']): ?>
              <li class="page-item disabled"><span class="page-link">...</span></li>
            <?php endif; ?>

            <li class="page-item <?= $pg['page'] >= $pg['totalPages'] ? 'disabled' : '' ?>">
              <a class="page-link" href="<?= wallet_url($pg['page'] + 1, $tx) ?>">&rsaquo;</a>
            </li>
            <li class="page-item <?= $pg['page'] >= $pg['totalPages'] ? 'disabled' : '' ?>">
              <a class="page-link" href="<?= wallet_url($pg['totalPages'], $tx) ?>">&raquo;</a>
            </li>
          </ul>
        </nav>
      </div>
      <?php endif; ?>
    </div>
  </div>
</div>
