<?php
$pdo = Db::pdo();
$memberId = (int)$member['id'];

$msg = null; $err = null;

// ambil profile bank + saldo
$st = $pdo->prepare("
  SELECT m.full_name, m.bank_name, m.bank_account, w.balance
  FROM members m
  LEFT JOIN wallets w ON w.member_id = m.id
  WHERE m.id=? LIMIT 1
");
$st->execute([$memberId]);
$me = $st->fetch();
if (!$me) { echo '<div class="alert alert-danger">Member tidak ditemukan.</div>'; return; }

$balance = (float)($me['balance'] ?? 0);

function rupiah($n){ return 'Rp ' . number_format((float)$n, 0, ',', '.'); }

// list WD terakhir
$st = $pdo->prepare("
  SELECT id, amount, status, note, requested_at, processed_at
  FROM withdraw_requests
  WHERE member_id=?
  ORDER BY id DESC
  LIMIT 50
");
$st->execute([$memberId]);
$rows = $st->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $amount = (float)str_replace([',','.'], ['',''], trim($_POST['amount'] ?? '0')); // input rupiah "50000" atau "50.000"
  if ($amount <= 0) $err = "Nominal WD tidak valid.";
  elseif ($amount < 50000) $err = "Minimal WD Rp 50.000.";
  elseif ($amount > $balance) $err = "Saldo tidak cukup.";
  elseif (trim((string)$me['full_name']) === '' || trim((string)$me['bank_name']) === '' || trim((string)$me['bank_account']) === '') {
    $err = "Profile bank belum lengkap. Isi dulu di menu Profile (Nama, Bank, No Rekening).";
  }

  if (!$err) {
    try {
      $pdo->beginTransaction();

      // lock wallet
      $st = $pdo->prepare("SELECT balance FROM wallets WHERE member_id=? LIMIT 1 FOR UPDATE");
      $st->execute([$memberId]);
      $w = $st->fetch();
      if (!$w) {
        $pdo->prepare("INSERT INTO wallets (member_id, balance) VALUES (?, 0.00)")->execute([$memberId]);
        $curBal = 0.0;
      } else {
        $curBal = (float)$w['balance'];
      }
      if ($amount > $curBal) throw new Exception("Saldo tidak cukup (terupdate).");

      // insert WD request
      $pdo->prepare("
        INSERT INTO withdraw_requests (member_id, amount, account_name, bank_name, bank_account, status, requested_at)
        VALUES (?, ?, ?, ?, ?, 'pending', NOW())
      ")->execute([
        $memberId,
        $amount,
        $me['full_name'],
        $me['bank_name'],
        $me['bank_account']
      ]);
      $wdId = (int)$pdo->lastInsertId();

      // potong saldo sekarang
      $pdo->prepare("UPDATE wallets SET balance = balance - ? WHERE member_id=?")
          ->execute([$amount, $memberId]);

      // catat transaksi (negatif)
      $desc = "Withdraw request #{$wdId} (pending)";
      $pdo->prepare("
        INSERT INTO wallet_transactions (member_id, tx_type, amount, description, ref_table, ref_id, created_at)
        VALUES (?, 'withdraw', ?, ?, 'withdraw_requests', ?, NOW())
      ")->execute([
        $memberId,
        -$amount,
        $desc,
        $wdId
      ]);

      $pdo->commit();
      $msg = "WD berhasil dibuat (#{$wdId}). Status: pending.";

      // refresh saldo & list
      $st = $pdo->prepare("SELECT balance FROM wallets WHERE member_id=? LIMIT 1");
      $st->execute([$memberId]);
      $balance = (float)($st->fetch()['balance'] ?? 0);

      $st = $pdo->prepare("
        SELECT id, amount, status, note, requested_at, processed_at
        FROM withdraw_requests
        WHERE member_id=?
        ORDER BY id DESC
        LIMIT 50
      ");
      $st->execute([$memberId]);
      $rows = $st->fetchAll();

    } catch (Throwable $e) {
      if ($pdo->inTransaction()) $pdo->rollBack();
      $err = $e->getMessage();
    }
  }
}
?>

<div class="row g-3">
  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body d-flex flex-wrap justify-content-between align-items-center gap-2">
        <div>
          <h5 class="mb-1">Withdraw</h5>
          <div class="text-secondary small">Request WD akan diproses admin.</div>
        </div>
        <div class="text-end">
          <div class="text-secondary small">Saldo</div>
          <div class="fs-4 fw-bold"><?= rupiah($balance) ?></div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-12">
    <?php if ($msg): ?><div class="alert alert-success"><?= e($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-danger"><?= e($err) ?></div><?php endif; ?>
  </div>

  <div class="col-12 col-lg-5">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-2">Form WD</h6>

        <div class="small text-secondary mb-2">
          Bank: <b><?= e($me['bank_name'] ?: '-') ?></b><br>
          Rek: <b><?= e($me['bank_account'] ?: '-') ?></b><br>
          Nama: <b><?= e($me['full_name'] ?: '-') ?></b>
        </div>

        <form method="post" class="row g-2" autocomplete="off">
          <div class="col-12">
            <label class="form-label mb-1">Nominal WD (min Rp 50.000)</label>
            <input class="form-control" name="amount" placeholder="contoh: 50000" required>
            <div class="form-text">Isi angka saja. Contoh: 50000</div>
          </div>

          <div class="col-12 mt-2">
            <button class="btn btn-primary w-100">
              <i class="bi bi-send me-1"></i> Kirim Request WD
            </button>
          </div>
        </form>

        <div class="small text-secondary mt-3">
          Catatan: saldo langsung dipotong saat request (mencegah double WD).
        </div>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-7">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-3">Riwayat WD (50 terakhir)</h6>
        <div class="table-responsive">
          <table class="table table-hover align-middle">
            <thead class="table-light">
              <tr>
                <th style="width:90px;">ID</th>
                <th style="width:160px;">Tanggal</th>
                <th style="width:160px;" class="text-end">Amount</th>
                <th style="width:120px;">Status</th>
                <th>Note</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($rows)): ?>
                <tr><td colspan="5" class="text-center text-secondary py-3">Belum ada WD.</td></tr>
              <?php else: foreach ($rows as $r): ?>
                <tr>
                  <td class="fw-semibold">#<?= (int)$r['id'] ?></td>
                  <td class="small text-secondary"><?= e($r['requested_at']) ?></td>
                  <td class="text-end fw-bold"><?= rupiah($r['amount']) ?></td>
                  <td>
                    <?php
                      $stt = $r['status'];
                      $cls = $stt==='approved' ? 'success' : ($stt==='rejected' ? 'danger' : 'warning');
                    ?>
                    <span class="badge bg-<?= $cls ?>"><?= e(strtoupper($stt)) ?></span>
                  </td>
                  <td class="small text-secondary"><?= e($r['note'] ?: '-') ?></td>
                </tr>
              <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
