<?php
// app/views/partials/member_sidebar.php
$current = $_GET['page'] ?? 'dashboard';
$BASE = '/jwdnetwork/member.php?page=';

// prefix unik untuk collapse ID (desk/mob)
$prefix = $prefix ?? 'desk';

if (!function_exists('active_member')) {
  function active_member($p, $cur) { return $p === $cur ? 'active' : ''; }
}
if (!function_exists('open_group')) {
  function open_group(array $pages, string $cur): string {
    return in_array($cur, $pages, true) ? 'show' : '';
  }
}
if (!function_exists('active_group')) {
  function active_group(array $pages, string $cur): string {
    return in_array($cur, $pages, true) ? 'active' : '';
  }
}
?>
<div class="sidebar-inner">

  <div class="sidebar-brand">
    <div class="brand-dot"></div>
    <div>
      <div class="fw-bold">JWD NETWORK</div>
      <div class="small text-white-50">Member</div>
    </div>
  </div>

  <div class="sidebar-user">
    <div class="avatar"><i class="bi bi-person-fill"></i></div>
    <div class="min-w-0">
      <div class="fw-semibold text-truncate"><?= e($_SESSION['auth']['username'] ?? 'member') ?></div>
      <div class="small text-white-50">ID: <?= (int)($_SESSION['auth']['id'] ?? 0) ?></div>
    </div>
  </div>

  <div class="sidebar-menu">

    <!-- SINGLE: REWARD -->
    <a class="menu-item <?= active_member('reward',$current) ?>" href="<?= $BASE ?>dashboard">
        <i class="bi bi-speedometer2 me-2"></i> Dashboard
    </a>

    <!-- GROUP: ACCOUNT -->
    <?php $g1 = ['profile','change_password']; $id1 = $prefix.'-grpAccount'; ?>
    <button class="menu-item menu-toggle <?= active_group($g1,$current) ?>"
            type="button"
            data-bs-toggle="collapse"
            data-bs-target="#<?= e($id1) ?>"
            aria-expanded="<?= open_group($g1,$current) ? 'true':'false' ?>">
      <span><i class="bi bi-person-circle me-2"></i> Account</span>
      <i class="bi bi-chevron-down small"></i>
    </button>
    <div class="collapse <?= open_group($g1,$current) ?>" id="<?= e($id1) ?>">
  
      <a class="menu-item sub <?= active_member('profile',$current) ?>" href="<?= $BASE ?>profile">
        <i class="bi bi-person-badge me-2"></i> Profile
      </a>
      <a class="menu-item sub <?= active_member('change_password',$current) ?>" href="<?= $BASE ?>change_password">
        <i class="bi bi-shield-lock me-2"></i> Change Password
      </a>
    </div>

    <!-- GROUP: PIN & REGISTER -->
    <?php $g2 = ['pins','register']; $id2 = $prefix.'-grpPins'; ?>
    <button class="menu-item menu-toggle <?= active_group($g2,$current) ?>"
            type="button"
            data-bs-toggle="collapse"
            data-bs-target="#<?= e($id2) ?>"
            aria-expanded="<?= open_group($g2,$current) ? 'true':'false' ?>">
      <span><i class="bi bi-upc-scan me-2"></i> PIN & Register</span>
      <i class="bi bi-chevron-down small"></i>
    </button>
    <div class="collapse <?= open_group($g2,$current) ?>" id="<?= e($id2) ?>">
      <a class="menu-item sub <?= active_member('pins',$current) ?>" href="<?= $BASE ?>pins">
        <i class="bi bi-key me-2"></i> PIN Saya
      </a>
      <a class="menu-item sub <?= active_member('register',$current) ?>" href="<?= $BASE ?>register">
        <i class="bi bi-person-plus me-2"></i> Register
      </a>
    </div>

    <!-- GROUP: NETWORK -->
    <?php $g3 = ['sponsor','network']; $id3 = $prefix.'-grpNetwork'; ?>
    <button class="menu-item menu-toggle <?= active_group($g3,$current) ?>"
            type="button"
            data-bs-toggle="collapse"
            data-bs-target="#<?= e($id3) ?>"
            aria-expanded="<?= open_group($g3,$current) ? 'true':'false' ?>">
      <span><i class="bi bi-diagram-3 me-2"></i> Network</span>
      <i class="bi bi-chevron-down small"></i>
    </button>
    <div class="collapse <?= open_group($g3,$current) ?>" id="<?= e($id3) ?>">
      <a class="menu-item sub <?= active_member('sponsor',$current) ?>" href="<?= $BASE ?>sponsor">
        <i class="bi bi-people me-2"></i> Sponsor Langsung
      </a>
      <a class="menu-item sub <?= active_member('network',$current) ?>" href="<?= $BASE ?>network">
        <i class="bi bi-diagram-3 me-2"></i> Binary Tree
      </a>
    </div>

    <!-- GROUP: WALLET -->
    <?php $g4 = ['wallet','reports','withdraw']; $id4 = $prefix.'-grpWallet'; ?>
    <button class="menu-item menu-toggle <?= active_group($g4,$current) ?>"
            type="button"
            data-bs-toggle="collapse"
            data-bs-target="#<?= e($id4) ?>"
            aria-expanded="<?= open_group($g4,$current) ? 'true':'false' ?>">
      <span><i class="bi bi-wallet2 me-2"></i> Wallet</span>
      <i class="bi bi-chevron-down small"></i>
    </button>
    <div class="collapse <?= open_group($g4,$current) ?>" id="<?= e($id4) ?>">
      <a class="menu-item sub <?= active_member('wallet',$current) ?>" href="<?= $BASE ?>wallet">
        <i class="bi bi-wallet2 me-2"></i> Wallet
      </a>
      <a class="menu-item sub <?= active_member('reports',$current) ?>" href="<?= $BASE ?>reports">
        <i class="bi bi-receipt me-2"></i> Reports
      </a>
      <a class="menu-item sub <?= active_member('withdraw',$current) ?>" href="<?= $BASE ?>withdraw">
        <i class="bi bi-cash-coin me-2"></i> Withdraw
      </a>
    </div>

    <!-- SINGLE: REWARD -->
    <a class="menu-item <?= active_member('reward',$current) ?>" href="<?= $BASE ?>reward">
      <i class="bi bi-award me-2"></i> Reward
    </a>

    <div class="menu-divider"></div>

    <a class="menu-item text-danger" href="/jwdnetwork/public/?r=logout">
      <i class="bi bi-box-arrow-right me-2"></i> Logout
    </a>

  </div>
</div>
