-- phpMyAdmin SQL Dump
-- version 4.7.4
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: 18 Jan 2026 pada 14.04
-- Versi Server: 10.1.29-MariaDB
-- PHP Version: 7.2.0

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `jwdnetwork`
--

-- --------------------------------------------------------

--
-- Struktur dari tabel `binary_closure`
--

CREATE TABLE `binary_closure` (
  `ancestor_id` bigint(20) NOT NULL,
  `descendant_id` bigint(20) NOT NULL,
  `depth` int(11) NOT NULL,
  `first_leg` enum('L','R') DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `binary_closure`
--

INSERT INTO `binary_closure` (`ancestor_id`, `descendant_id`, `depth`, `first_leg`) VALUES
(1, 1, 0, NULL),
(1, 2, 1, 'L'),
(2, 2, 0, NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `binary_placements`
--

CREATE TABLE `binary_placements` (
  `id` bigint(20) NOT NULL,
  `member_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) NOT NULL,
  `leg` enum('L','R') NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Struktur dari tabel `binary_tree`
--

CREATE TABLE `binary_tree` (
  `member_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `leg` enum('L','R') DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `binary_tree`
--

INSERT INTO `binary_tree` (`member_id`, `parent_id`, `leg`, `created_at`) VALUES
(1, NULL, NULL, '2026-01-18 15:33:45'),
(2, 1, 'L', '2026-01-18 15:34:32');

-- --------------------------------------------------------

--
-- Struktur dari tabel `members`
--

CREATE TABLE `members` (
  `id` bigint(20) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `full_name` varchar(120) DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `email` varchar(120) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `bank_name` varchar(80) DEFAULT NULL,
  `bank_account` varchar(40) DEFAULT NULL,
  `role` enum('admin','member') NOT NULL DEFAULT 'member',
  `sponsor_id` bigint(20) DEFAULT NULL,
  `package_id` int(11) DEFAULT NULL,
  `status` enum('pending','active','blocked') NOT NULL DEFAULT 'pending',
  `activated_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `members`
--

INSERT INTO `members` (`id`, `username`, `password_hash`, `full_name`, `phone`, `email`, `address`, `bank_name`, `bank_account`, `role`, `sponsor_id`, `package_id`, `status`, `activated_at`, `created_at`, `updated_at`) VALUES
(1, 'root', '$2y$10$GVAeh9CAdPgrQx6sSoFCS.yfmD3NNDYqoju71wuzKysnkvNPNJF0e', 'ROOT', NULL, NULL, NULL, NULL, NULL, 'admin', NULL, 2, 'active', '2026-01-18 15:33:08', '2026-01-18 15:33:08', '2026-01-18 16:54:20'),
(2, 'm2', '$2y$10$VRMyjgVV5IGRYsQDo38tFOccskTd759fKf8D7UPUetgv4SoPptE5i', 'Member 2', NULL, NULL, NULL, NULL, NULL, 'member', 1, 1, 'active', '2026-01-18 15:34:32', '2026-01-18 15:34:28', '2026-01-18 19:57:56');

-- --------------------------------------------------------

--
-- Struktur dari tabel `packages`
--

CREATE TABLE `packages` (
  `id` int(11) NOT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `price` decimal(14,2) NOT NULL DEFAULT '0.00',
  `sponsor_bonus` decimal(14,2) NOT NULL DEFAULT '0.00',
  `matching_bonus_per_pair` decimal(14,2) NOT NULL DEFAULT '0.00',
  `matching_max_gen` int(11) NOT NULL DEFAULT '0',
  `reward_point_value` int(11) NOT NULL DEFAULT '0',
  `is_daily_eligible` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `packages`
--

INSERT INTO `packages` (`id`, `code`, `name`, `price`, `sponsor_bonus`, `matching_bonus_per_pair`, `matching_max_gen`, `reward_point_value`, `is_daily_eligible`, `created_at`) VALUES
(1, 'WARRIOR', 'WARRIOR', '350000.00', '70000.00', '10000.00', 10, 0, 0, '2026-01-18 08:11:39'),
(2, 'SMART', 'SMART', '3500000.00', '500000.00', '50000.00', 20, 1, 1, '2026-01-18 08:11:39'),
(3, 'RICH', 'RICH', '7000000.00', '1000000.00', '100000.00', 100, 2, 1, '2026-01-18 08:11:39');

-- --------------------------------------------------------

--
-- Struktur dari tabel `pins_activation`
--

CREATE TABLE `pins_activation` (
  `id` bigint(20) NOT NULL,
  `pin_code` varchar(40) NOT NULL,
  `package_id` int(11) NOT NULL,
  `status` enum('unused','used') NOT NULL DEFAULT 'unused',
  `assigned_to_member_id` bigint(20) DEFAULT NULL,
  `assigned_note` varchar(255) DEFAULT NULL,
  `assigned_at` datetime DEFAULT NULL,
  `used_by_member_id` bigint(20) DEFAULT NULL,
  `used_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `pins_activation`
--

INSERT INTO `pins_activation` (`id`, `pin_code`, `package_id`, `status`, `assigned_to_member_id`, `assigned_note`, `assigned_at`, `used_by_member_id`, `used_at`, `created_at`) VALUES
(1, 'PIN-WARRIOR-E5BE492D', 1, 'unused', NULL, NULL, NULL, NULL, NULL, '2026-01-18 16:26:00'),
(2, 'PIN-WARRIOR-B57F7CE7', 1, 'unused', NULL, NULL, NULL, NULL, NULL, '2026-01-18 16:26:00'),
(3, 'PIN-WARRIOR-A312F153', 1, 'unused', NULL, NULL, NULL, NULL, NULL, '2026-01-18 16:26:00'),
(4, 'PIN-WARRIOR-2387C8A5', 1, 'unused', NULL, NULL, NULL, NULL, NULL, '2026-01-18 16:26:00'),
(5, 'PIN-WARRIOR-7C879DBA', 1, 'unused', NULL, NULL, NULL, NULL, NULL, '2026-01-18 16:26:00'),
(6, 'PIN-WARRIOR-789E9D15', 1, 'unused', 2, NULL, '2026-01-18 11:19:35', NULL, NULL, '2026-01-18 17:19:35');

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_bonus_matching`
--

CREATE TABLE `plan_a_bonus_matching` (
  `id` bigint(20) NOT NULL,
  `upline_id` bigint(20) NOT NULL,
  `from_member_id` bigint(20) NOT NULL,
  `generation` int(11) NOT NULL,
  `pair_count` int(11) NOT NULL DEFAULT '0',
  `amount` decimal(14,2) NOT NULL DEFAULT '0.00',
  `date_key` date NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_bonus_sponsor`
--

CREATE TABLE `plan_a_bonus_sponsor` (
  `id` bigint(20) NOT NULL,
  `sponsor_id` bigint(20) NOT NULL,
  `new_member_id` bigint(20) NOT NULL,
  `new_package_id` int(11) NOT NULL,
  `amount` decimal(14,2) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `plan_a_bonus_sponsor`
--

INSERT INTO `plan_a_bonus_sponsor` (`id`, `sponsor_id`, `new_member_id`, `new_package_id`, `amount`, `created_at`) VALUES
(1, 1, 2, 1, '70000.00', '2026-01-18 15:34:32');

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_daily_eligibility`
--

CREATE TABLE `plan_a_daily_eligibility` (
  `id` bigint(20) NOT NULL,
  `member_id` bigint(20) NOT NULL,
  `rule_code` enum('SMART_3SMART','RICH_3SMART','RICH_3RICH') NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `daily_amount` decimal(14,2) NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_daily_payouts`
--

CREATE TABLE `plan_a_daily_payouts` (
  `id` bigint(20) NOT NULL,
  `member_id` bigint(20) NOT NULL,
  `rule_code` enum('SMART_3SMART','RICH_3SMART','RICH_3RICH') NOT NULL,
  `date_key` date NOT NULL,
  `amount` decimal(14,2) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_matching_logs`
--

CREATE TABLE `plan_a_matching_logs` (
  `id` bigint(20) NOT NULL,
  `pair_event_id` bigint(20) NOT NULL,
  `receiver_id` bigint(20) NOT NULL,
  `gen` int(11) NOT NULL,
  `amount` decimal(14,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `plan_a_matching_logs`
--

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_monthly_omset`
--

CREATE TABLE `plan_a_monthly_omset` (
  `ym` char(7) NOT NULL,
  `total_omset` decimal(14,2) NOT NULL DEFAULT '0.00',
  `warrior_count` int(11) NOT NULL DEFAULT '0',
  `smart_count` int(11) NOT NULL DEFAULT '0',
  `rich_count` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_pairings`
--

CREATE TABLE `plan_a_pairings` (
  `id` bigint(20) NOT NULL,
  `member_id` bigint(20) NOT NULL,
  `date_key` date NOT NULL,
  `before_left` int(11) NOT NULL DEFAULT '0',
  `before_right` int(11) NOT NULL DEFAULT '0',
  `new_left` int(11) NOT NULL DEFAULT '0',
  `new_right` int(11) NOT NULL DEFAULT '0',
  `pairs` int(11) NOT NULL DEFAULT '0',
  `flush_qty` int(11) NOT NULL DEFAULT '0',
  `after_left` int(11) NOT NULL DEFAULT '0',
  `after_right` int(11) NOT NULL DEFAULT '0',
  `bonus_amount` decimal(14,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `plan_a_pairings`
--

INSERT INTO `plan_a_pairings` (`id`, `member_id`, `date_key`, `before_left`, `before_right`, `new_left`, `new_right`, `pairs`, `flush_qty`, `after_left`, `after_right`, `bonus_amount`, `created_at`) VALUES
(1, 1, '2026-01-18', 0, 0, 1, 0, 0, 0, 1, 0, '0.00', '2026-01-18 15:37:20'),
(2, 2, '2026-01-18', 0, 0, 0, 0, 0, 0, 0, 0, '0.00', '2026-01-18 15:37:20');

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_pair_events`
--

CREATE TABLE `plan_a_pair_events` (
  `id` bigint(20) NOT NULL,
  `member_id` bigint(20) NOT NULL,
  `pair_index` int(11) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `plan_a_pair_events`
--

INSERT INTO `plan_a_pair_events` (`id`, `member_id`, `pair_index`, `created_at`) VALUES
(1, 10, 1, '2026-01-18 23:23:39');

-- --------------------------------------------------------
--
-- Struktur dari tabel `plan_a_reward_claims`
--

CREATE TABLE `plan_a_reward_claims` (
  `id` bigint(20) NOT NULL,
  `member_id` bigint(20) NOT NULL,
  `level_id` int(11) NOT NULL,
  `left_at_claim` int(11) NOT NULL DEFAULT '0',
  `right_at_claim` int(11) NOT NULL DEFAULT '0',
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `notes` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_reward_levels`
--

CREATE TABLE `plan_a_reward_levels` (
  `id` int(11) NOT NULL,
  `level_code` varchar(30) NOT NULL,
  `left_need` int(11) NOT NULL,
  `right_need` int(11) NOT NULL,
  `reward_name` varchar(120) NOT NULL,
  `reward_value` decimal(14,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `plan_a_reward_levels`
--

INSERT INTO `plan_a_reward_levels` (`id`, `level_code`, `left_need`, `right_need`, `reward_name`, `reward_value`) VALUES
(1, 'MOTOR', 20, 20, 'Motor', '10000000.00'),
(2, 'BRIO', 200, 200, 'Brio', '120000000.00'),
(3, 'PAJERO', 1200, 1200, 'Pajero', '500000000.00');

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_reward_point_events`
--

CREATE TABLE `plan_a_reward_point_events` (
  `id` bigint(20) NOT NULL,
  `source_member_id` bigint(20) NOT NULL,
  `package_id` int(11) NOT NULL,
  `points` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_royalty_payouts`
--

CREATE TABLE `plan_a_royalty_payouts` (
  `id` bigint(20) NOT NULL,
  `ym` char(7) NOT NULL,
  `member_id` bigint(20) NOT NULL,
  `tier` enum('SMART','RICH') NOT NULL,
  `percent` decimal(6,3) NOT NULL,
  `pool_amount` decimal(14,2) NOT NULL,
  `member_count` int(11) NOT NULL,
  `amount` decimal(14,2) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Struktur dari tabel `plan_a_settings`
--

CREATE TABLE `plan_a_settings` (
  `k` varchar(80) NOT NULL,
  `v` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `plan_a_settings`
--

INSERT INTO `plan_a_settings` (`k`, `v`) VALUES
('DAILY_BONUS_AMOUNT', '50000'),
('DAILY_BONUS_DAYS', '90');

-- --------------------------------------------------------
--
-- Struktur dari tabel `sponsor_links`
--

CREATE TABLE `sponsor_links` (
  `id` bigint(20) NOT NULL,
  `sponsor_id` int(11) NOT NULL,
  `member_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------
--
-- Struktur dari tabel `wallets`
--

CREATE TABLE `wallets` (
  `member_id` bigint(20) NOT NULL,
  `balance` decimal(14,2) NOT NULL DEFAULT '0.00',
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `wallets`
--

INSERT INTO `wallets` (`member_id`, `balance`, `updated_at`) VALUES
(1, '70000.00', '2026-01-18 15:34:32'),
(2, '0.00', '2026-01-18 15:34:32');

-- --------------------------------------------------------

--
-- Struktur dari tabel `wallet_transactions`
--

CREATE TABLE `wallet_transactions` (
  `id` bigint(20) NOT NULL,
  `member_id` bigint(20) NOT NULL,
  `tx_type` varchar(40) NOT NULL,
  `amount` decimal(14,2) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ref_table` varchar(60) DEFAULT NULL,
  `ref_id` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `wallet_transactions`
--

INSERT INTO `wallet_transactions` (`id`, `member_id`, `tx_type`, `amount`, `description`, `ref_table`, `ref_id`, `created_at`) VALUES
(1, 1, 'sponsor', '70000.00', 'Bonus Sponsor dari member #2 (paket WARRIOR)', 'plan_a_bonus_sponsor', 1, '2026-01-18 15:34:32');

-- --------------------------------------------------------

--
-- Struktur dari tabel `withdraw_requests`
--

CREATE TABLE `withdraw_requests` (
  `id` bigint(20) NOT NULL,
  `member_id` bigint(20) NOT NULL,
  `amount` decimal(14,2) NOT NULL DEFAULT '0.00',
  `account_name` varchar(120) DEFAULT NULL,
  `bank_name` varchar(80) DEFAULT NULL,
  `bank_account` varchar(40) DEFAULT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `note` varchar(255) DEFAULT NULL,
  `requested_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `processed_at` datetime DEFAULT NULL,
  `processed_by` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data untuk tabel `withdraw_requests`
--

--
-- Indexes for dumped tables
--

--
-- Indexes for table `binary_closure`
--
ALTER TABLE `binary_closure`
  ADD PRIMARY KEY (`ancestor_id`,`descendant_id`),
  ADD KEY `idx_desc` (`descendant_id`),
  ADD KEY `idx_ancestor_leg` (`ancestor_id`,`first_leg`);

--
-- Indexes for table `binary_placements`
--
ALTER TABLE `binary_placements`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_member` (`member_id`),
  ADD UNIQUE KEY `uq_parent_leg` (`parent_id`,`leg`),
  ADD KEY `idx_parent` (`parent_id`);

--
-- Indexes for table `binary_tree`
--
ALTER TABLE `binary_tree`
  ADD PRIMARY KEY (`member_id`),
  ADD KEY `idx_parent` (`parent_id`),
  ADD KEY `idx_parent_leg` (`parent_id`,`leg`);

--
-- Indexes for table `members`
--
ALTER TABLE `members`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD KEY `idx_sponsor` (`sponsor_id`),
  ADD KEY `idx_package` (`package_id`),
  ADD KEY `idx_members_email` (`email`);

--
-- Indexes for table `packages`
--
ALTER TABLE `packages`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `pins_activation`
--
ALTER TABLE `pins_activation`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `pin_code` (`pin_code`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `fk_pin_pkg` (`package_id`),
  ADD KEY `fk_pin_used_by` (`used_by_member_id`),
  ADD KEY `idx_assigned_to` (`assigned_to_member_id`);

--
-- Indexes for table `plan_a_bonus_matching`
--
ALTER TABLE `plan_a_bonus_matching`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_match_once` (`upline_id`,`from_member_id`,`generation`,`date_key`),
  ADD KEY `idx_upline_date` (`upline_id`,`date_key`),
  ADD KEY `idx_from` (`from_member_id`);

--
-- Indexes for table `plan_a_bonus_sponsor`
--
ALTER TABLE `plan_a_bonus_sponsor`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_sponsor_newmember` (`new_member_id`),
  ADD KEY `idx_sponsor` (`sponsor_id`),
  ADD KEY `fk_bs_pkg` (`new_package_id`);

--
-- Indexes for table `plan_a_daily_eligibility`
--
ALTER TABLE `plan_a_daily_eligibility`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_member_rule` (`member_id`,`rule_code`),
  ADD KEY `idx_member_active` (`member_id`,`is_active`);

--
-- Indexes for table `plan_a_daily_payouts`
--
ALTER TABLE `plan_a_daily_payouts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_daily_once` (`member_id`,`rule_code`,`date_key`),
  ADD KEY `idx_date` (`date_key`);

--
-- Indexes for table `plan_a_monthly_omset`
--
ALTER TABLE `plan_a_monthly_omset`
  ADD PRIMARY KEY (`ym`);

--
-- Indexes for table `plan_a_pairings`
--
ALTER TABLE `plan_a_pairings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_member_date` (`member_id`,`date_key`),
  ADD KEY `idx_date` (`date_key`);

--
-- Indexes for table `plan_a_reward_claims`
--
ALTER TABLE `plan_a_reward_claims`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_member_level` (`member_id`,`level_id`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `fk_rc_level` (`level_id`);

--
-- Indexes for table `plan_a_reward_levels`
--
ALTER TABLE `plan_a_reward_levels`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `level_code` (`level_code`);

--
-- Indexes for table `plan_a_reward_point_events`
--
ALTER TABLE `plan_a_reward_point_events`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_source` (`source_member_id`),
  ADD KEY `fk_rpe_pkg` (`package_id`);

--
-- Indexes for table `plan_a_royalty_payouts`
--
ALTER TABLE `plan_a_royalty_payouts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_ym_member_tier` (`ym`,`member_id`,`tier`),
  ADD KEY `idx_ym` (`ym`),
  ADD KEY `fk_rp_member` (`member_id`);

--
-- Indexes for table `plan_a_settings`
--
ALTER TABLE `plan_a_settings`
  ADD PRIMARY KEY (`k`);

--
-- Indexes for table `wallets`
--
ALTER TABLE `wallets`
  ADD PRIMARY KEY (`member_id`);

--
-- Indexes for table `wallet_transactions`
--
ALTER TABLE `wallet_transactions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_member_date` (`member_id`,`created_at`),
  ADD KEY `idx_type` (`tx_type`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `binary_placements`
--
ALTER TABLE `binary_placements`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `members`
--
ALTER TABLE `members`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `packages`
--
ALTER TABLE `packages`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `pins_activation`
--
ALTER TABLE `pins_activation`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `plan_a_bonus_matching`
--
ALTER TABLE `plan_a_bonus_matching`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `plan_a_bonus_sponsor`
--
ALTER TABLE `plan_a_bonus_sponsor`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `plan_a_daily_eligibility`
--
ALTER TABLE `plan_a_daily_eligibility`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `plan_a_daily_payouts`
--
ALTER TABLE `plan_a_daily_payouts`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `plan_a_pairings`
--
ALTER TABLE `plan_a_pairings`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `plan_a_reward_claims`
--
ALTER TABLE `plan_a_reward_claims`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `plan_a_reward_levels`
--
ALTER TABLE `plan_a_reward_levels`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `plan_a_reward_point_events`
--
ALTER TABLE `plan_a_reward_point_events`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `plan_a_royalty_payouts`
--
ALTER TABLE `plan_a_royalty_payouts`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `wallet_transactions`
--
ALTER TABLE `wallet_transactions`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- Ketidakleluasaan untuk tabel pelimpahan (Dumped Tables)
--

--
-- Ketidakleluasaan untuk tabel `binary_closure`
--
ALTER TABLE `binary_closure`
  ADD CONSTRAINT `fk_bc_ancestor` FOREIGN KEY (`ancestor_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_bc_desc` FOREIGN KEY (`descendant_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `binary_placements`
--
ALTER TABLE `binary_placements`
  ADD CONSTRAINT `fk_bp_member` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_bp_parent` FOREIGN KEY (`parent_id`) REFERENCES `members` (`id`) ON DELETE CASCADE;

--
-- Ketidakleluasaan untuk tabel `binary_tree`
--
ALTER TABLE `binary_tree`
  ADD CONSTRAINT `fk_bt_member` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_bt_parent` FOREIGN KEY (`parent_id`) REFERENCES `members` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `members`
--
ALTER TABLE `members`
  ADD CONSTRAINT `fk_members_package` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_members_sponsor` FOREIGN KEY (`sponsor_id`) REFERENCES `members` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `pins_activation`
--
ALTER TABLE `pins_activation`
  ADD CONSTRAINT `fk_pin_assigned_to` FOREIGN KEY (`assigned_to_member_id`) REFERENCES `members` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_pin_pkg` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_pin_used_by` FOREIGN KEY (`used_by_member_id`) REFERENCES `members` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `plan_a_bonus_matching`
--
ALTER TABLE `plan_a_bonus_matching`
  ADD CONSTRAINT `fk_bm_from` FOREIGN KEY (`from_member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_bm_upline` FOREIGN KEY (`upline_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `plan_a_bonus_sponsor`
--
ALTER TABLE `plan_a_bonus_sponsor`
  ADD CONSTRAINT `fk_bs_newmember` FOREIGN KEY (`new_member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_bs_pkg` FOREIGN KEY (`new_package_id`) REFERENCES `packages` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_bs_sponsor` FOREIGN KEY (`sponsor_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `plan_a_daily_eligibility`
--
ALTER TABLE `plan_a_daily_eligibility`
  ADD CONSTRAINT `fk_de_member` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `plan_a_daily_payouts`
--
ALTER TABLE `plan_a_daily_payouts`
  ADD CONSTRAINT `fk_dp_member` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `plan_a_pairings`
--
ALTER TABLE `plan_a_pairings`
  ADD CONSTRAINT `fk_pair_member` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `plan_a_reward_claims`
--
ALTER TABLE `plan_a_reward_claims`
  ADD CONSTRAINT `fk_rc_level` FOREIGN KEY (`level_id`) REFERENCES `plan_a_reward_levels` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_rc_member` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `plan_a_reward_point_events`
--
ALTER TABLE `plan_a_reward_point_events`
  ADD CONSTRAINT `fk_rpe_pkg` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_rpe_source` FOREIGN KEY (`source_member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `plan_a_royalty_payouts`
--
ALTER TABLE `plan_a_royalty_payouts`
  ADD CONSTRAINT `fk_rp_member` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `wallets`
--
ALTER TABLE `wallets`
  ADD CONSTRAINT `fk_wallet_member` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `wallet_transactions`
--
ALTER TABLE `wallet_transactions`
  ADD CONSTRAINT `fk_wt_member` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
