<?php
session_start();

require __DIR__ . '/app/core/Helpers.php';
require __DIR__ . '/app/core/Db.php';

if (empty($_SESSION['auth']) || $_SESSION['auth']['role'] !== 'member') {
  redirect('/jwdnetwork/public/?r=login');
}

$page = $_GET['page'] ?? 'dashboard';

// whitelist pages (biar aman)
$allowed = ['dashboard','network','wallet','reports','pins','register','profile','withdraw','sponsor','reward','change_password'];

if (!in_array($page, $allowed, true)) $page = 'dashboard';

$viewFile = __DIR__ . "/app/views/member/{$page}.php";

// data global view
$member = [
  'id' => (int)$_SESSION['auth']['id'],
  'username' => $_SESSION['auth']['username'],
];

require __DIR__ . '/app/views/layouts/member.php';
