(function () {
  const navToggle = document.querySelector("[data-nav-toggle]");
  const navMenu = document.querySelector("[data-nav-menu]");

  if (navToggle && navMenu) {
    navToggle.addEventListener("click", () => {
      navMenu.classList.toggle("open");
    });
  }

  document.querySelectorAll("[data-dropdown-toggle]").forEach((btn) => {
    btn.addEventListener("click", (e) => {
      e.preventDefault();
      const item = btn.closest(".nav-item");
      if (!item) return;

      document.querySelectorAll(".nav-item.open").forEach((x) => {
        if (x !== item) x.classList.remove("open");
      });

      item.classList.toggle("open");
    });
  });

  document.addEventListener("click", (e) => {
    const insideMenu = e.target.closest(".nav-menu");
    const onToggle = e.target.closest("[data-nav-toggle]");
    if (!insideMenu && !onToggle) {
      document.querySelectorAll(".nav-item.open").forEach((x) => x.classList.remove("open"));
      if (navMenu) navMenu.classList.remove("open");
    }
  });
})();
