<?php
// scripts/activate_member.php
require __DIR__ . '/../app/core/Db.php';
require __DIR__ . '/../app/core/Helpers.php';
require __DIR__ . '/../app/services/BinaryService.php';

// ✅ TAMBAH INI
require __DIR__ . '/../app/services/Bonus/SponsorBonusService.php';

$pdo = Db::pdo();
header('Content-Type: application/json');

$memberId = isset($_GET['member_id']) ? (int)$_GET['member_id'] : 0;
$parentId = isset($_GET['parent_id']) ? (int)$_GET['parent_id'] : 0;
$leg      = isset($_GET['leg']) ? strtoupper(trim($_GET['leg'])) : '';

if ($memberId <= 0 || $parentId <= 0 || !in_array($leg, ['L','R'], true)) {
    echo json_encode(['ok'=>false,'error'=>'Param wajib: member_id, parent_id, leg=L/R'], JSON_PRETTY_PRINT);
    exit;
}

try {
    $pdo->beginTransaction();

    $st = $pdo->prepare("SELECT id, status, package_id FROM members WHERE id=? LIMIT 1");
    $st->execute([$memberId]);
    $m = $st->fetch();
    if (!$m) throw new Exception("Member tidak ditemukan");

    if ($m['status'] !== 'pending') {
        throw new Exception("Member status harus pending untuk aktivasi (sekarang: {$m['status']})");
    }
    if (empty($m['package_id'])) {
        throw new Exception("Member belum punya package_id");
    }

    // place ke binary
    $placed = BinaryService::place($pdo, $memberId, $parentId, $leg);

    // aktifkan member
    $pdo->prepare("UPDATE members SET status='active', activated_at=NOW() WHERE id=?")
        ->execute([$memberId]);

    // wallet auto untuk member baru
    ensure_wallet($pdo, $memberId);

    // ✅ JALANKAN BONUS SPONSOR SAAT AKTIVASI
    $sponsorBonus = SponsorBonusService::run($pdo, $memberId);

    $pdo->commit();

    echo json_encode([
        'ok' => true,
        'member_id' => $memberId,
        'placed_parent' => $placed['parent_id'],
        'leg' => $placed['leg'],
        'activated' => true,
        'sponsor_bonus' => $sponsorBonus
    ], JSON_PRETTY_PRINT);

} catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    echo json_encode(['ok'=>false,'error'=>$e->getMessage()], JSON_PRETTY_PRINT);
}
