<?php
session_start();
if (empty($_SESSION['auth']) || ($_SESSION['auth']['role'] ?? '') !== 'admin') {
  http_response_code(403); echo "Forbidden"; exit;
}
require __DIR__ . '/../app/core/Db.php';
require __DIR__ . '/../app/services/PlanAMatchingService.php';

$pdo = Db::pdo();
$target = (int)($_GET['member_id'] ?? 0);

try {
  $pdo->beginTransaction();

  if ($target > 0) {
    PlanAMatchingService::onNodeMaybePaired($pdo, $target);
    $count = 1;
  } else {
    $st = $pdo->query("
      SELECT parent_id
      FROM binary_placements
      GROUP BY parent_id
      HAVING SUM(CASE WHEN leg='L' THEN 1 ELSE 0 END) > 0
         AND SUM(CASE WHEN leg='R' THEN 1 ELSE 0 END) > 0
    ");
    $parents = array_map('intval', $st->fetchAll(PDO::FETCH_COLUMN));
    $count = 0;
    foreach ($parents as $pid) {
      PlanAMatchingService::onNodeMaybePaired($pdo, $pid);
      $count++;
    }
  }

  $pdo->commit();
  header('Content-Type: application/json');
  echo json_encode(['ok'=>true,'processed_nodes'=>$count,'target_member_id'=>$target ?: null]);
} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  header('Content-Type: application/json');
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()]);
}
