<?php
session_start();
if (empty($_SESSION['auth']) || ($_SESSION['auth']['role'] ?? '') !== 'admin') {
  http_response_code(403);
  echo "Forbidden";
  exit;
}

require __DIR__ . '/../app/core/Db.php';
require __DIR__ . '/../app/services/PlanARewardService.php';

$pdo = Db::pdo();

try {
  $pdo->beginTransaction();

  // Bersihkan dulu biar akurat (opsional tapi recommended)
  $pdo->exec("TRUNCATE TABLE plan_a_reward_points");
  $pdo->exec("TRUNCATE TABLE plan_a_reward_milestones");

  // Ambil semua member yang menghasilkan poin (SMART/RICH)
  $st = $pdo->query("SELECT id FROM members WHERE package_id IN (2,3) AND status='active'");
  $ids = array_map('intval', $st->fetchAll(PDO::FETCH_COLUMN));

  $done = 0;
  foreach ($ids as $mid) {
    // pakai service yang sama dengan register
    PlanARewardService::onMemberActivated($pdo, (int)$mid);
    $done++;
  }

  $pdo->commit();

  header('Content-Type: application/json');
  echo json_encode(['ok'=>true,'processed_members'=>$done]);
} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  header('Content-Type: application/json');
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()]);
}
