<?php
// scripts/export_withdrawals_csv.php

session_start();

// wajib admin
if (empty($_SESSION['auth']) || ($_SESSION['auth']['role'] ?? '') !== 'admin') {
  http_response_code(403);
  echo "Forbidden";
  exit;
}

// include Db + helper e()
require __DIR__ . '/../app/core/Db.php';
require __DIR__ . '/../app/core/helpers.php';

$pdo = Db::pdo();

$status = strtolower(trim($_GET['status'] ?? 'pending'));
if (!in_array($status, ['pending','approved','rejected','all'], true)) $status = 'pending';

$where = "1=1";
$params = [];
if ($status !== 'all') {
  $where .= " AND w.status=?";
  $params[] = $status;
}

// ambil semua data
$st = $pdo->prepare("
  SELECT
    w.id,
    m.username,
    w.amount,
    w.status,
    w.account_name,
    w.bank_name,
    w.bank_account,
    w.note,
    w.requested_at,
    w.processed_at,
    w.processed_by
  FROM withdraw_requests w
  JOIN members m ON m.id = w.member_id
  WHERE {$where}
  ORDER BY w.id DESC
");
$st->execute($params);
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

// bersihin output buffer biar header aman
while (ob_get_level()) { ob_end_clean(); }

$filename = 'withdrawals_' . $status . '_' . date('Ymd_His') . '.csv';

header('Content-Type: text/csv; charset=UTF-8');
header('Content-Disposition: attachment; filename="'.$filename.'"');
header('Pragma: no-cache');
header('Expires: 0');

$out = fopen('php://output', 'w');

// BOM UTF-8 untuk Excel
fwrite($out, "\xEF\xBB\xBF");

// header kolom
fputcsv($out, [
  'id','username','amount','status',
  'account_name','bank_name','bank_account',
  'note','requested_at','processed_at','processed_by'
]);

foreach ($rows as $r) {
  fputcsv($out, [
    $r['id'],
    $r['username'],
    (string)$r['amount'],
    $r['status'],
    $r['account_name'],
    $r['bank_name'],
    $r['bank_account'],
    $r['note'],
    $r['requested_at'],
    $r['processed_at'],
    $r['processed_by'],
  ]);
}

fclose($out);
exit;
