<?php
// scripts/generate_pins.php
require __DIR__ . '/../app/core/Db.php';
$pdo = Db::pdo();
header('Content-Type: application/json');

$packageCode = strtoupper(trim($_GET['pkg'] ?? 'WARRIOR')); // WARRIOR/SMART/RICH
$qty = isset($_GET['qty']) ? (int)$_GET['qty'] : 5;
if ($qty < 1) $qty = 1;
if ($qty > 200) $qty = 200;

$st = $pdo->prepare("SELECT id FROM packages WHERE code=? LIMIT 1");
$st->execute([$packageCode]);
$pkg = $st->fetch();
if (!$pkg) { echo json_encode(['ok'=>false,'error'=>'Paket tidak ditemukan'], JSON_PRETTY_PRINT); exit; }

$packageId = (int)$pkg['id'];
$pins = [];

for ($i=0; $i<$qty; $i++) {
  $pin = 'PIN-' . $packageCode . '-' . strtoupper(bin2hex(random_bytes(4)));

  $pdo->prepare("INSERT INTO pins_activation (pin_code, package_id, status) VALUES (?, ?, 'unused')")
      ->execute([$pin, $packageId]);

  $pins[] = $pin;
}

echo json_encode(['ok'=>true,'package'=>$packageCode,'qty'=>$qty,'pins'=>$pins], JSON_PRETTY_PRINT);
