<?php
require __DIR__ . '/../app/core/Db.php';

$pdo = Db::pdo();
header('Content-Type: application/json');

$username = trim($_GET['username'] ?? '');
$newPass  = (string)($_GET['pass'] ?? '');

if ($username === '' || $newPass === '') {
  echo json_encode(['ok'=>false,'error'=>'Param wajib: username, pass'], JSON_PRETTY_PRINT);
  exit;
}

$st = $pdo->prepare("SELECT id, role FROM members WHERE username=? LIMIT 1");
$st->execute([$username]);
$u = $st->fetch();
if (!$u) {
  echo json_encode(['ok'=>false,'error'=>'User tidak ditemukan'], JSON_PRETTY_PRINT);
  exit;
}

$hash = password_hash($newPass, PASSWORD_BCRYPT);
$pdo->prepare("UPDATE members SET password_hash=? WHERE id=?")->execute([$hash, (int)$u['id']]);

echo json_encode([
  'ok'=>true,
  'username'=>$username,
  'role'=>$u['role'],
  'password_set'=>true
], JSON_PRETTY_PRINT);
