<?php
// scripts/run_matching.php
require __DIR__ . '/../app/core/Db.php';
require __DIR__ . '/../app/core/Helpers.php';

$pdo = Db::pdo();

$dateKey = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
header('Content-Type: application/json');

function get_member(PDO $pdo, int $id): ?array {
    $st = $pdo->prepare("SELECT id, sponsor_id, package_id, status FROM members WHERE id=? LIMIT 1");
    $st->execute([$id]);
    $row = $st->fetch();
    return $row ?: null;
}

function get_package(PDO $pdo, int $packageId): ?array {
    $st = $pdo->prepare("SELECT id, code, matching_bonus_per_pair, matching_max_gen FROM packages WHERE id=? LIMIT 1");
    $st->execute([$packageId]);
    $row = $st->fetch();
    return $row ?: null;
}

try {
    $rows = $pdo->prepare("
        SELECT member_id, pairs
        FROM plan_a_pairings
        WHERE date_key=? AND pairs > 0
    ");
    $rows->execute([$dateKey]);
    $pairingRows = $rows->fetchAll();

    $pdo->beginTransaction();

    $payoutCount = 0;

    foreach ($pairingRows as $r) {
        $fromMemberId = (int)$r['member_id']; // downline yang menghasilkan pairs
        $pairs = (int)$r['pairs'];

        // sponsor chain
        $gen = 1;
        $current = get_member($pdo, $fromMemberId);
        if (!$current) continue;

        $sponsorId = (int)($current['sponsor_id'] ?? 0);

        while ($sponsorId > 0) {
            $upline = get_member($pdo, $sponsorId);
            if (!$upline) break;
            if ($upline['status'] !== 'active') {
                // kalau sponsor tidak aktif, tetap lanjut ke atas? biasanya STOP.
                // biar simple: STOP
                break;
            }

            $pkgId = (int)($upline['package_id'] ?? 0);
            if ($pkgId <= 0) break;

            $pkg = get_package($pdo, $pkgId);
            if (!$pkg) break;

            $maxGen = (int)$pkg['matching_max_gen'];
            if ($gen > $maxGen) {
                // upline ini tidak dapat (gen lewat), tapi upline di atasnya mungkin punya max lebih besar?
                // tapi gen makin besar, kalau ini sudah lewat max, yang atas pasti gen lebih besar lagi.
                break;
            }

            $rate = (float)$pkg['matching_bonus_per_pair'];
            $amount = $pairs * $rate;

            // insert matching (idempotent)
            $stmt = $pdo->prepare("
                INSERT IGNORE INTO plan_a_bonus_matching
                  (upline_id, from_member_id, generation, pair_count, amount, date_key)
                VALUES
                  (?, ?, ?, ?, ?, ?)
            ");
            $stmt->execute([$upline['id'], $fromMemberId, $gen, $pairs, $amount, $dateKey]);

            // kalau benar-benar insert baru, baru kredit wallet
            if ($stmt->rowCount() > 0) {
                $desc = "Matching Gen {$gen} dari pairs member #{$fromMemberId} ({$pairs} pasang)";
                wallet_credit($pdo, (int)$upline['id'], (float)$amount, 'matching', $desc, 'plan_a_pairings', $fromMemberId);
                $payoutCount++;
            }

            // naik ke sponsor berikutnya
            $gen++;
            $sponsorId = (int)($upline['sponsor_id'] ?? 0);
        }
    }

    $pdo->commit();

    echo json_encode([
        'ok' => true,
        'date_key' => $dateKey,
        'source_pairings' => count($pairingRows),
        'matching_payout_rows' => $payoutCount
    ], JSON_PRETTY_PRINT);

} catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    echo json_encode(['ok' => false, 'error' => $e->getMessage()], JSON_PRETTY_PRINT);
}
