<?php
// scripts/run_pairing.php
require __DIR__ . '/../app/core/Db.php';

$pdo = Db::pdo();

// date_key bisa dipaksa lewat ?date=YYYY-MM-DD
$dateKey = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');

header('Content-Type: application/json');

try {
    // ambil semua member aktif (yang berhak dihitung pairing)
    $members = $pdo->query("SELECT id FROM members WHERE status='active' AND role='member'")->fetchAll();

    $pdo->beginTransaction();

    $results = [];
    foreach ($members as $m) {
        $memberId = (int)$m['id'];

        // ambil carry terakhir (after_left/right dari pairing terakhir)
        $stmt = $pdo->prepare("
            SELECT after_left, after_right
            FROM plan_a_pairings
            WHERE member_id=? AND date_key < ?
            ORDER BY date_key DESC
            LIMIT 1
        ");
        $stmt->execute([$memberId, $dateKey]);
        $prev = $stmt->fetch();

        $beforeLeft  = $prev ? (int)$prev['after_left']  : 0;
        $beforeRight = $prev ? (int)$prev['after_right'] : 0;

        // NEW LEFT: jumlah descendant aktif yang activated_at = dateKey dan first_leg='L'
        $stmt = $pdo->prepare("
            SELECT COUNT(*) AS c
            FROM binary_closure bc
            JOIN members d ON d.id = bc.descendant_id
            WHERE bc.ancestor_id = ?
              AND bc.depth > 0
              AND bc.first_leg = 'L'
              AND d.status = 'active'
              AND DATE(d.activated_at) = ?
        ");
        $stmt->execute([$memberId, $dateKey]);
        $newLeft = (int)$stmt->fetch()['c'];

        // NEW RIGHT
        $stmt = $pdo->prepare("
            SELECT COUNT(*) AS c
            FROM binary_closure bc
            JOIN members d ON d.id = bc.descendant_id
            WHERE bc.ancestor_id = ?
              AND bc.depth > 0
              AND bc.first_leg = 'R'
              AND d.status = 'active'
              AND DATE(d.activated_at) = ?
        ");
        $stmt->execute([$memberId, $dateKey]);
        $newRight = (int)$stmt->fetch()['c'];

        $availLeft  = $beforeLeft  + $newLeft;
        $availRight = $beforeRight + $newRight;

        $pairs = min($availLeft, $availRight);

        $afterLeft  = $availLeft  - $pairs;
        $afterRight = $availRight - $pairs;

        // simpan pairing harian (idempotent by uq_member_date)
        $stmt = $pdo->prepare("
            INSERT INTO plan_a_pairings
              (member_id, date_key, before_left, before_right, new_left, new_right, pairs, flush_qty, after_left, after_right, bonus_amount)
            VALUES
              (?, ?, ?, ?, ?, ?, ?, 0, ?, ?, 0.00)
            ON DUPLICATE KEY UPDATE
              before_left=VALUES(before_left),
              before_right=VALUES(before_right),
              new_left=VALUES(new_left),
              new_right=VALUES(new_right),
              pairs=VALUES(pairs),
              after_left=VALUES(after_left),
              after_right=VALUES(after_right)
        ");
        $stmt->execute([
            $memberId, $dateKey,
            $beforeLeft, $beforeRight,
            $newLeft, $newRight,
            $pairs,
            $afterLeft, $afterRight
        ]);

        $results[] = [
            'member_id' => $memberId,
            'date_key' => $dateKey,
            'before_left' => $beforeLeft,
            'before_right' => $beforeRight,
            'new_left' => $newLeft,
            'new_right' => $newRight,
            'pairs' => $pairs,
            'after_left' => $afterLeft,
            'after_right' => $afterRight,
        ];
    }

    $pdo->commit();

    echo json_encode(['ok' => true, 'date_key' => $dateKey, 'count' => count($results), 'data' => $results], JSON_PRETTY_PRINT);
} catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    echo json_encode(['ok' => false, 'error' => $e->getMessage()], JSON_PRETTY_PRINT);
}
