<?php
// scripts/set_password.php
require __DIR__ . '/../app/core/Db.php';

$pdo = Db::pdo();
header('Content-Type: application/json');

$memberId = isset($_GET['member_id']) ? (int)$_GET['member_id'] : 0;
$newPass  = isset($_GET['pass']) ? (string)$_GET['pass'] : '';

if ($memberId <= 0 || $newPass === '') {
  echo json_encode(['ok'=>false,'error'=>'Param wajib: member_id, pass'], JSON_PRETTY_PRINT);
  exit;
}

try {
  $hash = password_hash($newPass, PASSWORD_BCRYPT);

  $st = $pdo->prepare("UPDATE members SET password_hash=? WHERE id=?");
  $st->execute([$hash, $memberId]);

  echo json_encode([
    'ok' => true,
    'member_id' => $memberId,
    'password_set' => true
  ], JSON_PRETTY_PRINT);

} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()], JSON_PRETTY_PRINT);
}
